/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentResult.cpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FragmentResult.hpp"

/** Constructor of class FragmentResult.
 *
 * \param _id id of FragmntJob associated to this FragmentResult.
 */
FragmentResult::FragmentResult(const JobId_t _id) :
  JobId(_id),
  result(std::string("Nothing"))
{}

/** Constructor of class FragmentResult.
 */
FragmentResult::FragmentResult(const JobId_t _id, const std::string _result) :
  JobId(_id),
  result(_result)
{}

/** Copy constructor of class FragmentResult.
 *
 */
FragmentResult::FragmentResult(const FragmentResult &other) :
  JobId(other.getId()),
  result(other.result)
{}

/** Destructor of class FragmentResult.
 *
 */
FragmentResult::~FragmentResult()
{}

/** Equality operator: Equal if both JobIds are the same
 *
 * \param other instance to check against
 * \return true - both JobIds are the same, false - JobIds are not the same.
 */
bool FragmentResult::operator==(const FragmentResult &other) const
{
  return getId() == other.getId();
}

/** Assigment operator.
 *
 * \note We can't use default assigment because of const member FragmentResult::JobId.
 *
 * \param other instance to make equal to
 */
FragmentResult& FragmentResult::operator=(const FragmentResult &other)
{
  /// check self-assignment
  if (this != &other) {
    setId(other.getId());
    result = other.result;
  }
  return *this;
}
