/** \file helpers.hpp
 *
 * Declaration of some auxiliary functions for memory dis-/allocation and so on 
 */

#ifndef HELPERS_HPP_
#define HELPERS_HPP_

using namespace std;

#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <math.h>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "defs.hpp"

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/********************************************** helpful functions *********************************/

// taken out of TREMOLO
/*@-namechecks@*/
#ifndef __GNUC__
# undef __attribute__
# define __attribute__(x)
#endif
/*@=namechecks@*/

/* Behandelt aufgetretene Fehler. error ist der Fehlertyp(enum Errors)
   void *SpecialData ist ein untypisierter Zeiger auf Spezielle Daten zur Fehlerbehandlung.
   Man koennte auch noch einen Zeiger auf eine Funktion uebergeben */
extern void /*@exits@*/ debug(const char *output);
  //__attribute__ ((__return__));
#define debug(data) debug_in((data), __FILE__, __LINE__)

extern void /*@exits@*/ debug_in(const char *output,
    const char *file, const int line);
  //__attribute__ ((__return__));

double ask_value(const char *text);
bool check_bounds(double *x, double *cell_size);
void bound(double *b, double lower_bound, double upper_bound);
void flip(double *x, double *y);
int pot(int base, int n);
void * Malloc(size_t size, const char* output);
void * Calloc(size_t size, const char* output);
void * ReAlloc(void * OldPointer, size_t size, const char* output);
char* MallocString(size_t size, const char* output);
void Free(void ** buffer, const char* output);
char *FixedDigitNumber(const int FragmentNumber, const int digits);

/********************************************** helpful template functions *********************************/

/** Creates a lookup table for true father's Atom::Nr -> atom ptr.
 * \param *out output stream for debugging
 * \param *start begin of chain list
 * \paran *end end of chain list
 * \param **Lookuptable pointer to return allocated lookup table (should be NULL on start)
 * \param count optional predetermined count for table (otherwise we set the count to highest true father id)
 * \return true - success, false - failure
 */
template <typename T> bool CreateFatherLookupTable(ofstream *out, T *start, T *end, T **&LookupTable, int count = 0)
{
  bool status = true;
  T *Walker = NULL;
  int AtomNo;
  
  if (LookupTable != NULL) {
    *out << "Pointer for Lookup table is not NULL! Aborting ..." <<endl;
    return false;
  }
  
  // count them
  if (count == 0) {
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::nr -> atom) used as a marker table lateron 
      Walker = Walker->next;
      count = (count < Walker->GetTrueFather()->nr) ? Walker->GetTrueFather()->nr : count;
    }
  }
  if (count <= 0) {
    *out << "Count of lookup list is 0 or less." << endl;
    return false;
  }

  // allocat and fill
  LookupTable = (T **) Malloc(sizeof(T *)*count, "CreateFatherLookupTable - **LookupTable");
  if (LookupTable == NULL) {
    cerr << "LookupTable memory allocation failed!" << endl;
    status = false;
  } else {
    Walker = start;
    while (Walker->next != end) { // create a lookup table (Atom::nr -> atom) used as a marker table lateron 
      Walker = Walker->next;
      AtomNo = Walker->GetTrueFather()->nr;
      if ((AtomNo >= 0) && (AtomNo < count)) {
        //*out << "Setting LookupTable[" << AtomNo << "] to " << *Walker << endl;
        LookupTable[AtomNo] = Walker;
      } else {
        *out << "Walker " << *Walker << " exceeded range of nuclear ids [0, " << count << ")." << endl; 
        status = false;
        break;
      }
    }
  }
  
  return status; 
};



/******************************** Some templates for list management ***********************************/

/** Adds linking of an item to a list.
 * \param *walker
 * \return true - adding succeeded, false - error in list
 */
template <typename X> void link(X *walker, X *end)
{
  X *vorher = end->previous;
  if (vorher != NULL)
    vorher->next = walker;
  end->previous = walker;
  walker->previous = vorher;
  walker->next = end;
};

/** Removes linking of an item in a list.
 * \param *walker
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void unlink(X *walker)
{
  if (walker->next != NULL) 
    walker->next->previous = walker->previous;
  if (walker->previous != NULL)
    walker->previous->next = walker->next;
};

/** Adds new item before an item \a *end in a list.
 * \param *pointer   item to be added
 * \param *end  end of list
 * \return true - addition succeeded, false - unable to add item to list
 */
template <typename X>  bool add(X *pointer, X *end)
{
  if (end != NULL) {
    link(pointer, end);
  } else {
    pointer->previous = NULL;
    pointer->next = NULL; 
  }
  return true;
};

/** Finds item in list
 * \param *suche  search criteria
 * \param *start  begin of list
 * \param *end  end of list
 * \return X - if found, NULL - if not found
 */
template <typename X, typename Y> X * find(Y *suche, X *start, X *end)
{
  X *walker = start;
  while (walker->next != end) { // go through list
    walker = walker->next; // step onward beforehand
    if (*walker->sort == *suche) return (walker);
  }
  return NULL;
};

/** Removes an item from the list without check.
 * \param *walker item to be removed
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void removewithoutcheck(X *walker)
{
  if (walker != NULL) {
    unlink(walker);
    delete(walker);
    walker = NULL;
  }
};

/** Removes an item from the list, checks if exists.
 * Checks beforehand if atom is really within molecule list.
 * \param *pointer   item to be removed
 * \param *start  begin of list
 * \param *end  end of list
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> bool remove(X *pointer, X *start, X *end)
{
  X *walker = find (pointer->sort, start, end);
/*  while (walker->next != pointer) { // search through list
    walker = walker->next;
    if (walker == end) return false;  // item not found in list
  }*/
  // atom found, now unlink
  if (walker != NULL)
    removewithoutcheck(walker);
  else
    return false;
  return true;
};

/** Cleans the whole list.
 * \param *start begin of list
 * \param *end end of list
 * \return true - list was cleaned successfully, false - error in list structure
 */
template <typename X> bool cleanup(X *start, X *end)
{
  X *pointer = start->next;
  X *walker;
  while (pointer != end) { // go through list
    walker = pointer; // mark current
    pointer = pointer->next; // step onward beforehand
    // remove walker
    unlink(walker);
    delete(walker);
    walker = NULL;
  }
  return true;
};

/** Returns the first marker in a chain list.
 * \param *me one arbitrary item in chain list
 * \return poiner to first marker
 */
template <typename X> X *GetFirst(X *me)
{
  X *Binder = me;
  while(Binder->previous != NULL)
    Binder = Binder->previous;
  return Binder;
}; 

/** Returns the last marker in a chain list.
 * \param *me one arbitrary item in chain list
 * \return poiner to last marker
 */
template <typename X> X *GetLast(X *me)
{
  X *Binder = me;
  while(Binder->next != NULL)
    Binder = Binder->next;
  return Binder;
}; 

/** Frees a two-dimensional array.
 * \param *ptr pointer to array
 * \param dim first dim of array
 */
template <typename X> void Free2DArray(X **ptr, int dim)
{
  int i;
  if (ptr != NULL) {
    for(i=dim;i--;)
      if (ptr[i] != NULL)
        free(ptr[i]);
    free(ptr);
  }
};

/************************************* Class Verbose & Binary *******************************/

/** Verbose is an IO manipulator, that writes tabs according to \a Verbosity level.
 */
class Verbose
{
  public:
    Verbose(int value) : Verbosity(value) { }

    ostream& print (ostream &ost) const;
  private:
    int Verbosity;
};

ostream& operator<<(ostream& ost,const Verbose& m);

/** Binary is an IO manipulator, that writes 0 and 1 according to number \a Binary.
 */
class Binary
{
  public:
    Binary(int value) : BinaryNumber(value) { }

    ostream& print (ostream &ost) const;
  private:
    int BinaryNumber;
};

ostream& operator<<(ostream& ost,const Binary& m);



#endif /*HELPERS_HPP_*/
