/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QDoubleSpinBox>
#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/VectorQtQueryPipe.hpp"


QtDialog::VectorQtQuery::VectorQtQuery(std::string title, bool _check,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::VectorQuery(title,_check),
    parent(_parent)
{
  mainLayout= new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  mainLayout->addWidget(titleLabel);
  subLayout = new QVBoxLayout();
  mainLayout->addLayout(subLayout);
  QComboBox* inputBox = new QComboBox();
  coordLayout = new QHBoxLayout();
  subLayout->addLayout(coordLayout);
  coordLabel = new QLabel(QString("x,y,z"));
  coordLayout->addWidget(coordLabel);
  coordInputX = new QDoubleSpinBox();
//  coordInputX->setRange(0,M.at(i,i));
  coordInputX->setDecimals(3);
  coordLayout->addWidget(coordInputX);
  coordInputY = new QDoubleSpinBox();
//  coordInputY->setRange(0,M.at(i,i));
  coordInputY->setDecimals(3);
  coordLayout->addWidget(coordInputY);
  coordInputZ = new QDoubleSpinBox();
//  coordInputZ->setRange(0,M.at(i,i));
  coordInputZ->setDecimals(3);
  coordLayout->addWidget(coordInputZ);
  pipe = new VectorQtQueryPipe(&(tmp),_dialog,inputBox);
  //pipe->update(coordInput->value());
  connect(coordInputX,SIGNAL(valueChanged(double)),pipe,SLOT(updateX(double)));
  connect(coordInputY,SIGNAL(valueChanged(double)),pipe,SLOT(updateY(double)));
  connect(coordInputZ,SIGNAL(valueChanged(double)),pipe,SLOT(updateZ(double)));
  parent->addLayout(mainLayout);
}

QtDialog::VectorQtQuery::~VectorQtQuery()
{}

bool QtDialog::VectorQtQuery::handle() {
  return true;
}


