/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/Pipe/VectorQtQueryPipe.hpp"
#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qcombobox.h>

#include "CodePatterns/MemDebug.hpp"


VectorQtQueryPipe::VectorQtQueryPipe(Vector *_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

VectorQtQueryPipe::~VectorQtQueryPipe()
{}

void VectorQtQueryPipe::updateX(double newDouble) {
  (*content)[0] = newDouble;
  dialog->update();
}

void VectorQtQueryPipe::updateY(double newDouble) {
  (*content)[1] = newDouble;
  dialog->update();
}

void VectorQtQueryPipe::updateZ(double newDouble) {
  (*content)[2] = newDouble;
  dialog->update();
}

