/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SerializablePotentialUnitTest.cpp
 *
 *  Created on: Nov 23, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "SerializablePotentialUnitTest.hpp"

#include <boost/assign.hpp>
#include <sstream>

#include "CodePatterns/Assert.hpp"

#include "Potentials/Exceptions.hpp"
#include "Potentials/SerializablePotential.hpp"

using namespace boost::assign;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( SerializablePotentialTest );


void SerializablePotentialTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);
}


void SerializablePotentialTest::tearDown()
{
}

/** UnitTest for operator<<()
 */
void SerializablePotentialTest::outputTest()
{
  {
  std::stringstream outstream;
  CPPUNIT_ASSERT_NO_THROW(outstream << mockpotential);
  CPPUNIT_ASSERT_EQUAL(
      std::string("serializablepotentialmock:\tparticle_type1=1,\tdummy_constant=0;"),
      outstream.str()
      );
  }
}

/** UnitTest for derivative>>()
 */
void SerializablePotentialTest::inputTest()
{
  {
    std::stringstream instream(
        std::string("\tserializablepotentialmock:\tparticle_type1=1,\tdummy_constant=1;")
    );
    CPPUNIT_ASSERT_NO_THROW(instream >> mockpotential);
    CPPUNIT_ASSERT_EQUAL(
    		FunctionModel::parameter_t(1),
        mockpotential.getParameters()[0]);
  }
  {
    std::stringstream illegalkeystream(
        std::string("\tserializablepotentialmock:\tparticle_type1=1,\tdummy_wrong=0;")
    );
    CPPUNIT_ASSERT_THROW(
        illegalkeystream >> mockpotential,
        SerializerIllegalKeyException);
    CPPUNIT_ASSERT_EQUAL(
    		FunctionModel::parameter_t(1),
        mockpotential.getParameters()[0]);
  }
  {
    std::stringstream missingvaluestream(
        std::string("\tserializablepotentialmock:\tparticle_type1=1,\tdummy_constant;")
    );
    CPPUNIT_ASSERT_THROW(
        missingvaluestream >> mockpotential,
        SerializerMissingValueException);
    CPPUNIT_ASSERT_EQUAL(
    		FunctionModel::parameter_t(1),
        mockpotential.getParameters()[0]);
  }
}
