/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * teapotview.cpp
 *
 *  Created on: Aug 16, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "teapotview.hpp"
#include "qglbuilder.h"
#include "qglscenenode.h"
#include "qglcube.h"

#include "CodePatterns/MemDebug.hpp"

void TeapotView::initializeGL(QGLPainter *painter)
{
  QGLBuilder builder;
  builder << QGL::Faceted;
  builder << QGLCube();
  teapot = builder.finalizedSceneNode();
}

TeapotView::~TeapotView()
{
  delete teapot;
}

void TeapotView::paintGL(QGLPainter *painter)
{
  painter->setStandardEffect(QGL::LitMaterial);
  painter->setFaceColor(QGL::AllFaces, QColor(170, 202, 0));

  painter->modelViewMatrix().rotate(45.0f, 1.0f, 1.0f, 1.0f);
  teapot->draw(painter);
}
