#ifndef LINKEDCELL_HPP_
#define LINKEDCELL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "molecules.hpp"

#define LinkedAtoms list <atom *>

class LinkedCell{
  public:
    Vector max;       // upper boundary
    Vector min;       // lower boundary
    LinkedAtoms *LC;  // linked cell list
    double RADIUS;    // cell edge length
    int N[NDIM];      // number of cells per axis
    int n[NDIM];      // temporary variable for current cell per axis
    int index;        // temporary index variable , access by index = n[0] * N[1] * N[2] + n[1] * N[2] + n[2];

    LinkedCell();
    LinkedCell(molecule *mol, double RADIUS);
    ~LinkedCell();
    LinkedAtoms* GetCurrentCell();
    bool SetIndexToAtom(atom *Walker);
    bool SetIndexToVector(Vector *x);
    bool CheckBounds();

    // not implemented yet
    bool AddAtom(atom *Walker);
    bool DeleteAtom(atom *Walker);
    bool MoveAtom(atom *Walker);
};

#endif /*LINKEDCELL_HPP_*/
