/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VMGData.cpp
 *
 *  Created on: Aug 6, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "VMGData.hpp"

#include <iostream>

VMGData::VMGData(const SamplingGridProperties &_props) :
  sampled_potential(_props),
  nuclei_long(0.),
  electron_long(0.),
  hasForces(false),
  relative_residual(0.),
  precision(0.)
{}

VMGData::VMGData() :
    nuclei_long(0.),
    electron_long(0.),
    hasForces(false),
    relative_residual(0.),
    precision(0.)
{}

std::ostream & operator<<(std::ostream &ost, const VMGData &data)
{
  ost << "Nuclei long-Range energy: " << data.nuclei_long << std::endl;
  ost << "Electron long-Range energy: " << data.electron_long << std::endl;
  ost << "Nuclei long-Range forces: " << data.forces << std::endl;
  ost << "Relative residual: " << data.relative_residual << std::endl;
  ost << "Desired precision: " << data.precision << std::endl;
  return ost;
}
