/* \file toString.hpp
 *
 * contains template functions that allow for casting various types to strings.
 *
 *  Created on: Nov 14, 2010
 *      Author: heber
 */

#ifndef TOSTRING_HPP_
#define TOSTRING_HPP_

#include <iostream>
#include <string>
#include <sstream>

#include <list>
#include <map>
#include <set>
#include <vector>

/** Converter for any class to string.
 * We use default conversion via stringstream as suggested by [Stroustrup].
 * \param _&_object reference to object to convert to string.
 * \return string converted \a _object
 */
template <class T> std::string toString(T const &_object)
{
  std::stringstream s;
  s << _object;
  return s.str();
}


/** Operator for output to std::ostream operator of an std::list of arbitrary
 * type.
 * @param ost output stream
 * @param vector list of types to output
 * @return ost output stream
 */
template <class T> std::ostream & operator<<(std::ostream &ost, const std::list< T > &_vector)
{
  ost << "( ";
  for (typename std::list< T >::const_iterator iter = _vector.begin();
      iter != _vector.end();
      ++iter)
    ost << *iter << "; ";
  ost << ")";
  return ost;
}


/** Operator for output to std::ostream operator of an std::map of arbitrary
 * type.
 * @param ost output stream
 * @param vector map of types to output
 * @return ost output stream
 */
template <class T, class S> std::ostream & operator<<(std::ostream &ost, const std::map< T, S > &_vector)
{
  ost << "{ ";
  for (typename std::map< T, S >::const_iterator iter = _vector.begin();
      iter != _vector.end();
      ++iter)
    ost << "(" << iter->first << ")=>(" << iter->second << "); ";
  ost << "}";
  return ost;
}


/** Operator for output to std::ostream operator of an std::multimap of arbitrary
 * type.
 * @param ost output stream
 * @param multimap map of types to output
 * @return ost output stream
 */
template <class T, class S> std::ostream & operator<<(std::ostream &ost, const std::multimap< T, S > &_vector)
{
  ost << "{ ";
  for (typename std::multimap< T, S >::const_iterator iter = _vector.begin();
      iter != _vector.end();
      ++iter)
    ost << "(" << iter->first << ")=>(" << iter->second << "); ";
  ost << "}";
  return ost;
}


/** Operator for output to std::ostream operator of an std::set of arbitrary
 * type.
 * @param ost output stream
 * @param set list of types to output
 * @return ost output stream
 */
template <class T> std::ostream & operator<<(std::ostream &ost, const std::set< T > &_vector)
{
  ost << "( ";
  for (typename std::set< T >::const_iterator iter = _vector.begin();
      iter != _vector.end();
      ++iter)
    ost << *iter << "; ";
  ost << ")";
  return ost;
}


/** Operator for output to std::ostream operator of an std::vector of arbitrary
 * type.
 * @param ost output stream
 * @param vector vector of types to output
 * @return ost output stream
 */
template <class T> std::ostream & operator<<(std::ostream &ost, const std::vector< T > &_vector)
{
  ost << "( ";
  for (typename std::vector< T >::const_iterator iter = _vector.begin();
      iter != _vector.end();
      ++iter)
    ost << *iter << "; ";
  ost << ")";
  return ost;
}


#endif /* TOSTRING_HPP_ */
