/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParameterStorage.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Parser/Parameters/ParameterStorage.hpp"
#include "CodePatterns/Registry_impl.hpp"

/** Constructor for class ParameterStorage.
 */
ParameterStorage::ParameterStorage()
{}

/** Copy constructor for class ParameterStorage.
 *
 * We need to make our own copy constructor as we have to clone all
 * stored parameters.
 *
 */
ParameterStorage::ParameterStorage(const ParameterStorage &_storage)
{
  for (const_iterator iter = _storage.getBeginIter(); iter != _storage.getEndIter(); ++iter) {
    ParameterInterface *instance = (iter->second)->clone();
    registerInstance(instance);
  }
}

/** Destructor for class ParameterStorage.
 */
ParameterStorage::~ParameterStorage()
{
  cleanup();
}

CONSTRUCT_REGISTRY(ParameterInterface)
