/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObservedContainerTest.cpp
 *
 *  Created on: Jan 19, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>
#include <map>

#include "CodePatterns/Assert.hpp"

#include <iostream>

#include "stubs/ObserverStub.hpp"
#include "CodePatterns/Observer/ObservedContainer.hpp"
#include "CodePatterns/Observer/ObservedContainer_impl.hpp"
#include "CodePatterns/Observer/ObservedIterator.hpp"
#include "CodePatterns/Observer/UnobservedIterator.hpp"

#include "ObservedContainerUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ObservedContainerTest );

/******************* Test stubs ************************/


/******************* actuall tests ***************/

void ObservedContainerTest::setUp() {
  ASSERT_DO(Assert::Throw);
  simpleObservable1 = new SimpleObservable();
}

void ObservedContainerTest::tearDown() {
  delete simpleObservable1;
}

void ObservedContainerTest::IteratorMapTest()
{
  typedef ObservedContainer< std::map<int, int>, ObservedIterator<std::map<int, int> > > OC;
  OC OContainer(simpleObservable1);
  int i;

  OContainer.insert( std::pair<int,int> (1,1) );
  OContainer.insert( std::pair<int,int> (2,2) );

  i=0;
  for (OC::internal_iterator iter = OContainer.begin_internal(); iter != OContainer.end_internal(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=0;
  for (OC::iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=0;
  for (OC::const_iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=3;
  for (OC::reverse_internal_iterator iter = OContainer.rbegin_internal(); iter != OContainer.rend_internal(); ++iter) {
    i--;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);

  /* @todo TODO: Check whether dereferencing ObservedContainer::reverse_iterator
   *  is working now.
   * I am quite convinced that the reason for us having to use a
   * const_reverse_iterator below is in stl_iterator.h, where operator* is
   * implemented with a temporary _Iterator that is returned, i.e. a
   * temporary object and we are not allowed to dereference from this
   * temporary object.
   */
  i=3;
  for (OC::reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
    i--;
    OC::const_reverse_iterator helper = iter;
    CPPUNIT_ASSERT_EQUAL(i, helper->first);
    CPPUNIT_ASSERT_EQUAL(i, helper->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);

  i=3;
  for (OC::const_reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
    i--;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);
}

void ObservedContainerTest::IteratorMapNotObservedTest()
{
  typedef ObservedContainer< std::map<int, int>, UnobservedIterator<std::map<int, int> > > OC;
  OC OContainer(simpleObservable1);
  int i;

  OContainer.insert( std::pair<int,int> (1,1) );
  OContainer.insert( std::pair<int,int> (2,2) );

  i=0;
  for (OC::internal_iterator iter = OContainer.begin_internal(); iter != OContainer.end_internal(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=0;
  for (OC::iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=0;
  for (OC::const_iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
    i++;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,2);

  i=3;
  for (OC::reverse_internal_iterator iter = OContainer.rbegin_internal(); iter != OContainer.rend_internal(); ++iter) {
    i--;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);

  /* @todo TODO: Check whether dereferencing ObservedContainer::reverse_iterator
   *  is working now.
   * I am quite convinced that the reason for us having to use a
   * const_reverse_iterator below is in stl_iterator.h, where operator* is
   * implemented with a temporary _Iterator that is returned, i.e. a
   * temporary object and we are not allowed to dereference from this
   * temporary object.
   */
  i=3;
  for (OC::reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
    i--;
    OC::const_reverse_iterator helper = iter;
    CPPUNIT_ASSERT_EQUAL(i, helper->first);
    CPPUNIT_ASSERT_EQUAL(i, helper->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);

  i=3;
  for (OC::const_reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
    i--;
    CPPUNIT_ASSERT_EQUAL(i, iter->first);
    CPPUNIT_ASSERT_EQUAL(i, iter->second);
  }
  CPPUNIT_ASSERT_EQUAL(i,1);
}

// @todo TODO: Check whether ObservedContainer with sets not maps is working now
void ObservedContainerTest::IteratorSetTest()
{
//  typedef ObservedContainer< std::set<int>, ObservedIterator<std::set<int> > > OC;
//  OC OContainer(simpleObservable1);
//  int i;
//
//  OContainer.insert(1);
//  OContainer.insert(2);
//
//  i=0;
//  for (OC::internal_iterator iter = OContainer.begin_internal(); iter != OContainer.end_internal(); ++iter) {
//    i++;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,2);
//
//  i=0;
//  for (OC::iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
//    i++;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,2);
//
//  i=0;
//  for (OC::const_iterator iter = OContainer.begin(); iter != OContainer.end(); ++iter) {
//    i++;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,2);
//
//  i=3;
//  for (OC::reverse_internal_iterator iter = OContainer.rbegin_internal(); iter != OContainer.rend_internal(); ++iter) {
//    i--;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,1);
//
//  i=3;
//  for (OC::reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
//    i--;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,1);
//
//  i=3;
//  for (OC::const_reverse_iterator iter = OContainer.rbegin(); iter != OContainer.rend(); ++iter) {
//    i--;
//    CPPUNIT_ASSERT_EQUAL(i, *iter);
//  }
//  CPPUNIT_ASSERT_EQUAL(i,1);
}
