/*
 * AtomSet_impl.hpp
 *
 *  Created on: Jul 8, 2010
 *      Author: crueger
 */

#ifndef OBSERVEDCONTAINER_IMPL_HPP_
#define OBSERVEDCONTAINER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Observer/ObservedContainer.hpp"

template <class Container, class Iterator>
inline ObservedContainer<Container, Iterator>::ObservedContainer(Observable* _obs) :
  obs(_obs)
{}

template <class Container, class Iterator>
inline ObservedContainer<Container, Iterator>::ObservedContainer(const ObservedContainer<Container, Iterator> &src) :
  content(src.content),
  obs(src.obs)
{}

template <class Container, class Iterator>
inline ObservedContainer<Container, Iterator>::~ObservedContainer()
{}

template <class Container, class Iterator>
inline
ObservedContainer<Container, Iterator>&
ObservedContainer<Container, Iterator>::operator=(const ObservedContainer<Container, Iterator> &rhs){
  content=rhs.content;
  return *this;
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::iterator
ObservedContainer<Container, Iterator>::begin(){
  return ObservedContainer<Container, Iterator>::iterator(content.begin(),obs);
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::const_iterator
ObservedContainer<Container, Iterator>::begin() const{
  return content.begin();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::iterator
ObservedContainer<Container, Iterator>::end(){
  return ObservedContainer<Container, Iterator>::iterator(content.end(),obs);
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::const_iterator
ObservedContainer<Container, Iterator>::end() const{
  return content.end();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::reverse_iterator
ObservedContainer<Container, Iterator>::rbegin(){
  return reverse_iterator(end());
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::const_reverse_iterator
ObservedContainer<Container, Iterator>::rbegin() const{
  return const_reverse_iterator(end());
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::reverse_iterator
ObservedContainer<Container, Iterator>::rend(){
  return reverse_iterator(begin());
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::const_reverse_iterator
ObservedContainer<Container, Iterator>::rend() const{
  return const_reverse_iterator(begin());
}

template <class Container, class Iterator>
inline bool ObservedContainer<Container, Iterator>::empty() const{
  return content.empty();
}

template <class Container, class Iterator>
inline size_t ObservedContainer<Container, Iterator>::size() const{
  return content.size();
}

template <class Container, class Iterator>
inline size_t ObservedContainer<Container, Iterator>::max_size() const{
  return content.max_size();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::mapped_type &
ObservedContainer<Container, Iterator>::operator[](const key_type &key){
  return content[key];
}

template <class Container, class Iterator>
inline
std::pair<typename ObservedContainer<Container, Iterator>::iterator,bool>
ObservedContainer<Container, Iterator>::insert (const value_type &value){
  std::pair<typename set_t::iterator,bool> res = content.insert(value);
  return std::make_pair(iterator(res.first,obs),res.second);
}

template <class Container, class Iterator>
inline size_t ObservedContainer<Container, Iterator>::erase ( const key_type& x ){
  return content.erase(x);
}

template <class Container, class Iterator>
inline void ObservedContainer<Container, Iterator>::clear(){
  content.clear();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::iterator
ObservedContainer<Container, Iterator>::find ( const key_type& x ){
  return iterator(content.find(x),obs);
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::const_iterator
ObservedContainer<Container, Iterator>::find ( const key_type& x ) const{
  return content.find(x);
}

template <class Container, class Iterator>
inline size_t ObservedContainer<Container, Iterator>::count ( const key_type& x ) const{
  return content.count(x);
}

/************ Unprotected access ***************/

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::internal_iterator
ObservedContainer<Container, Iterator>::begin_internal(){
  return content.begin();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::internal_iterator
ObservedContainer<Container, Iterator>::end_internal(){
  return content.end();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::reverse_internal_iterator
ObservedContainer<Container, Iterator>::rbegin_internal(){
  return content.rbegin();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::reverse_internal_iterator
ObservedContainer<Container, Iterator>::rend_internal(){
  return content.rend();
}

template <class Container, class Iterator>
inline
typename ObservedContainer<Container, Iterator>::set_t &
ObservedContainer<Container, Iterator>::getContent(){
  return content;
}

/************ Explicit instantiation ***************/

#define CONSTRUCT_OBSERVEDCONTAINER(container, name) \
    template ObservedContainer< container, name >& ObservedContainer< container, name >::operator=(const ObservedContainer< container, name >&); \
    template ObservedContainer< container, name >::iterator ObservedContainer< container, name >::begin(); \
    template ObservedContainer< container, name >::const_iterator ObservedContainer< container, name >::begin() const; \
    template ObservedContainer< container, name >::iterator ObservedContainer< container, name >::end(); \
    template ObservedContainer< container, name >::const_iterator ObservedContainer< container, name >::end() const; \
    template ObservedContainer< container, name >::reverse_iterator ObservedContainer< container, name >::rbegin(); \
    template ObservedContainer< container, name >::const_reverse_iterator ObservedContainer< container, name >::rbegin() const; \
    template ObservedContainer< container, name >::reverse_iterator ObservedContainer< container, name >::rend(); \
    template ObservedContainer< container, name >::const_reverse_iterator ObservedContainer< container, name >::rend() const; \
    template bool ObservedContainer< container, name >::empty() const; \
    template size_t ObservedContainer< container, name >::size() const; \
    template size_t ObservedContainer< container, name >::max_size() const; \
    template ObservedContainer< container, name >::mapped_type &ObservedContainer< container, name >::operator[](const key_type&); \
    template std::pair<ObservedContainer< container, name >::iterator,bool> ObservedContainer< container, name >::insert (const value_type&); \
    template size_t ObservedContainer< container, name >::erase ( const key_type& x ); \
    template void ObservedContainer< container, name >::clear(); \
    template ObservedContainer< container, name >::iterator ObservedContainer< container, name >::find ( const key_type& x ); \
    template ObservedContainer< container, name >::const_iterator ObservedContainer< container, name >::find ( const key_type& x ) const; \
    template size_t ObservedContainer< container, name >::count ( const key_type& x ) const; \
    template ObservedContainer< container, name >::internal_iterator ObservedContainer< container, name >::begin_internal(); \
    template ObservedContainer< container, name >::reverse_internal_iterator ObservedContainer< container, name >::rbegin_internal(); \
    template ObservedContainer< container, name >::internal_iterator ObservedContainer< container, name >::end_internal(); \
    template ObservedContainer< container, name >::reverse_internal_iterator ObservedContainer< container, name >::rend_internal(); \

#endif /* OBSERVEDCONTAINER_IMPL_HPP_ */
