/*
 * PotentialTrainer.hpp
 *
 *  Created on: Sep 11, 2014
 *      Author: heber
 */

#ifndef POTENTIALTRAINER_HPP_
#define POTENTIALTRAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/filesystem/path.hpp>
#include <vector>

#include "Potentials/SerializablePotential.hpp"

class element;
class HomologyContainer;
class HomologyGraph;

/** This class is a functor for training a (compound) potential from homologies.
 *
 */
class PotentialTrainer
{
public:
  PotentialTrainer();
  ~PotentialTrainer();

  bool operator()(
        const HomologyContainer &_homologies,
        const HomologyGraph &_graph,
        const boost::filesystem::path &_trainingfile,
        const double _threshold,
        const unsigned int _best_of_howmany) const;

  static
  HomologyGraph getFirstGraphwithSpecifiedElements(
      const HomologyContainer &homologies,
      const SerializablePotential::ParticleTypes_t &types);

  static
  SerializablePotential::ParticleTypes_t getNumbersFromElements(
      const std::vector<const element *> &fragment);
};


#endif /* POTENTIALTRAINER_HPP_ */
