/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

#include <string>

#include "Dialog.hpp"

class atom;
class element;
class molecule;
class Vector;

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryEmpty(const char *, std::string = "");
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryInt(const char *, std::string = "");
  virtual void queryString(const char*, std::string = "");
  virtual void queryStrings(const char*, std::string = "");
  virtual void queryDouble(const char*, std::string = "");
  virtual void queryAtom(const char*,std::string = "");
  virtual void queryMolecule(const char*,std::string = "");
  virtual void queryVector(const char*,bool, std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*, std::string = "");

protected:
  // specialized stuff for text queries
  class EmptyTextQuery : public Dialog::EmptyQuery {
  public:
    EmptyTextQuery(std::string title, std::string _description = NULL);
    virtual ~EmptyTextQuery();
    virtual bool handle();
  };

  class BooleanTextQuery : public Dialog::BooleanQuery {
  public:
    BooleanTextQuery(std::string title, std::string _description = NULL);
    virtual ~BooleanTextQuery();
    virtual bool handle();
  };

  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, std::string _description = NULL);
    virtual ~IntTextQuery();
    virtual bool handle();
  };

  class DoubleTextQuery : public Dialog::DoubleQuery {
  public:
    DoubleTextQuery(std::string title, std::string _description = NULL);
    virtual ~DoubleTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string _description = NULL);
    virtual ~StringTextQuery();
    virtual bool handle();
  };

  class StringsTextQuery : public Dialog::StringsQuery {
  public:
    StringsTextQuery(std::string title, std::string _description = NULL);
    virtual ~StringsTextQuery();
    virtual bool handle();
  };

  class AtomTextQuery : public Dialog::AtomQuery {
  public:
    AtomTextQuery(std::string title, std::string _description = NULL);
    virtual ~AtomTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, std::string _description = NULL);
    virtual ~MoleculeTextQuery();
    virtual bool handle();
  };

  class VectorTextQuery : public Dialog::VectorQuery {
  public:
    VectorTextQuery(std::string title,bool _check, std::string _description = NULL);
    virtual ~VectorTextQuery();
    virtual bool handle();
  };

  class BoxTextQuery : public Dialog::BoxQuery {
  public:
    BoxTextQuery(std::string title, std::string _description = NULL);
    virtual ~BoxTextQuery();
    virtual bool handle();
  };

  class ElementTextQuery : public Dialog::ElementQuery {
  public:
    ElementTextQuery(std::string title, std::string _description = NULL);
    virtual ~ElementTextQuery();
    virtual bool handle();
  };
};

#endif /* TEXTDIALOG_HPP_ */
