/*
 * ReceiveResultsOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_RECEIVERESULTSOPERATION_HPP_
#define FRAGMENTCONTROLLER_RECEIVERESULTSOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"
#include "Results/FragmentResult.hpp"

#include "Controller/Commands/AsyncOperation.hpp"

class ReceiveResultsOperation : public AsyncOperation  {
public:
  /// Constructor for class ReceiveResultsOperation.
  ReceiveResultsOperation(Connection &_connection) :
    AsyncOperation(std::string("receiveresults"), _connection) {}
  /// Destructor for class ReceiveResultsOperation
  ~ReceiveResultsOperation() {}

public:
  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when results are about to be received.
  void handle_ReceivingResults(const boost::system::error_code& e);

  /// Callback function when results have been received.
  void handle_ReceivedResults(const boost::system::error_code& e);

  /// Getter for results
  std::vector<FragmentResult::ptr> getResults();

protected:
  /// bunch of results
  std::vector<FragmentResult::ptr> results;
};

#endif /* FRAGMENTCONTROLLER_RECEIVERESULTSOPERATION_HPP_ */
