/*
 * Shape_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_IMPL_HPP_
#define SHAPE_IMPL_HPP_

#include <vector>

#include "Shapes/Shape.hpp"

class Vector;

class Shape_impl {
public:
  Shape_impl(){};
  virtual ~Shape_impl(){};
  virtual bool isInside(const Vector &point)=0;
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const=0;
};

class Everywhere_impl : public Shape_impl {
public:
  virtual bool isInside(const Vector &point){
    return true;
  }
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const {
    std::vector<Vector> PointsOnSurface;
    return PointsOnSurface;
  }
};

class Nowhere_impl : public Shape_impl {
  virtual bool isInside(const Vector &point){
    return false;
  }
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const {
    std::vector<Vector> PointsOnSurface;
    return PointsOnSurface;
  }
};

class AndShape_impl : public Shape_impl {
public:
  AndShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~AndShape_impl();
  virtual bool isInside(const Vector &point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class OrShape_impl : public Shape_impl {
public:
  OrShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~OrShape_impl();
  virtual bool isInside(const Vector &point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class NotShape_impl : public Shape_impl {
public:
  NotShape_impl(const Shape::impl_ptr&);
  virtual ~NotShape_impl();
  virtual bool isInside(const Vector &point);
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr arg;
};

Shape::impl_ptr getShapeImpl(const Shape&);

#endif /* SHAPE_IMPL_HPP_ */
