/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */
/*
 * CloneUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */
// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CloneUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Assert.hpp"

#include "CodePatterns/Clone.hpp"
#include "stubs/CloneStub.hpp"

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( CloneTest );


void CloneTest::setUp()
{
  ip1 = &p1;
  CPPUNIT_ASSERT( ip1 == &p1 );
  ip2 = &p2;
  CPPUNIT_ASSERT( ip2 == &p2 );

  ip1_1 = NULL;
  ip1_2 = NULL;
  ip2_1 = NULL;
  ip2_2 = NULL;
}

void CloneTest::tearDown()
{
  // NULL pointer may be deleted.
  delete ip1_1;
  delete ip1_2;
  delete ip2_1;
  delete ip2_2;
}

void CloneTest::CreationTest()
{
  // test that new instances have been created.
  ip1_1 = p1.clone();
  ip1_2 = p1.clone();
  CPPUNIT_ASSERT( ip1 != ip1_1 );
  CPPUNIT_ASSERT( ip1 != ip1_2 );

  ip2_1 = p2.clone();
  ip2_2 = p2.clone();
  CPPUNIT_ASSERT( ip2 != ip2_1 );
  CPPUNIT_ASSERT( ip2 != ip2_2 );
}

void CloneTest::IndividualityTest()
{
  CPPUNIT_ASSERT( typeid(p1).name() != typeid(p2).name() );
  p1.count();
  p2.count();
  p2.count();

  // make refs to interface
  ip1 = &p1;
  CPPUNIT_ASSERT( ip1 == &p1 );
  ip2 = &p2;
  CPPUNIT_ASSERT( ip2 == &p2 );

  // clone (i.e. counter = p?.counter ), ...
  ip1_1 = p1.clone();
  ip1_2 = p1.clone();
  ip2_1 = p2.clone();
  ip2_2 = p2.clone();

  // check that each is individual
  CPPUNIT_ASSERT_EQUAL( ip1->getcount(), ip1_1->getcount() );
  CPPUNIT_ASSERT_EQUAL( ip1->getcount(), ip1_2->getcount() );
  CPPUNIT_ASSERT_EQUAL( ip2->getcount(), ip2_1->getcount() );
  CPPUNIT_ASSERT_EQUAL( ip2->getcount(), ip2_2->getcount() );

  // increase individual counters and check against others
  ip1_1->count();
  CPPUNIT_ASSERT( ip1->getcount() != ip1_1->getcount() );
  CPPUNIT_ASSERT( ip1_1->getcount() != ip1_2->getcount() );
  CPPUNIT_ASSERT( ip1->getcount() == ip1_2->getcount() );

  ip1_2->count();
  CPPUNIT_ASSERT( ip1_1->getcount() == ip1_2->getcount() );
  CPPUNIT_ASSERT( ip1->getcount() != ip1_2->getcount() );

  ip1_2->count();
  CPPUNIT_ASSERT( ip1_1->getcount() != ip1_2->getcount() );
  CPPUNIT_ASSERT( ip1->getcount()   != ip1_2->getcount() );
}
