/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * logunittest.cpp
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "LogUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LogTest );


void LogTest::setUp()
{
};

void LogTest::tearDown()
{
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/**
 * UnitTest for log()
 */
void LogTest::logTest()
{
  logger::getInstance().setVerbosity(2);
  // long form
  DoLog(0) && (Log() << Verbose(0) << "Verbosity level is set to 2." << endl);
  // shortform via macro
  LOG(0,"Test level 0");
  LOG(1,"Test level 1");
  LOG(2,"Test level 2");
  LOG(3,"Test level 3");
  LOG(4,"Test level 4");

  DoLog(0) && (Log() << Verbose(0) << "Output a log message." << endl);
  DoeLog(0) && (eLog()<< Verbose(0) << "Output an error message." << endl);
  CPPUNIT_ASSERT(DoLog(0));
  setVerbosity(3);
  DoLog(4) && (Log() << Verbose(4) << "This should not be printed." << endl);
  DoeLog(4) && (eLog()<< Verbose(4) << "This should not be printed." << endl);
  CPPUNIT_ASSERT(!DoLog(4));
  CPPUNIT_ASSERT(!DoeLog(4));
};
