/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IteratorAdaptorsUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>

#include "CodePatterns/IteratorAdaptors.hpp"
#include "CodePatterns/Log.hpp"

#include "IteratorAdaptorsUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( IteratorAdaptorsTest );


void IteratorAdaptorsTest::setUp()
{
  vecKeys.push_back(31);
  vecKeys.push_back(59);
  vecValues.push_back(41);
  vecValues.push_back(26);
  map[31] = 41;
  map[59] = 26;
}


void IteratorAdaptorsTest::tearDown()
{
  vecKeys.clear();
  vecValues.clear();
  map.clear();
}

/** UnitTest for FunctionTest().
 */
void IteratorAdaptorsTest::FunctionTest()
{

  typedef MapValueIterator< std::map<int,int>::iterator > ValueIter;
  typedef MapKeyIterator< std::map<int,int>::iterator > KeyIter;
  typedef std::vector<int>::iterator vecIter;
  ValueIter value_iter = ValueIter(map.begin());
  KeyIter key_iter = KeyIter(map.begin());
  vecIter value_iter2 = vecValues.begin();
  vecIter key_iter2 = vecKeys.begin();
  while ( (value_iter != ValueIter(map.end())) && (value_iter2 != vecValues.end())
      && (key_iter != KeyIter(map.end())) && (key_iter2 != vecKeys.end()) ) {
    CPPUNIT_ASSERT( *key_iter == *key_iter2 );
    CPPUNIT_ASSERT( *value_iter == *value_iter2 );
    ++key_iter;
    ++key_iter2;
    ++value_iter;
    ++value_iter2;
  }
}
