/*
 * ObserverLog.hpp
 *
 *  Created on: Dec 1, 2011
 *      Author: heber
 */

#ifndef OBSERVERLOG_HPP_
#define OBSERVERLOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/shared_ptr.hpp>
#include <map>
#include <set>
#include <iosfwd>
#include <string>
#include <sstream>

#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Observer/Observer.hpp"
#include "CodePatterns/Singleton.hpp"

/**
 * This class is used to log the working of the observer mechanism
 *
 * TODO: make this conditional dependent on compiler Flag.
 */
class ObserverLog : public Singleton<ObserverLog> {
  friend class Observable;
  friend class Observer;
  friend class Relay;
  template <typename> friend class Cacheable;
  friend class Singleton<ObserverLog>;
public:
  std::string getLog();                        // get everything that has been logged
  std::string getName(void*);                  // get the name of an actor
  bool isObservable(void*);
  void disableLogging();
  void enableLogging();

  /** tiny helper class to allow for both capturing and printing of messages.
   *
   */
  class Log {
  public:
    Log(ObserverLog *_callback_ref);
    ~Log();

    std::stringstream log;                      // the internal stream that later gets appended
    ObserverLog *callback_ref;                  // internal stringstream to capture messages
  };

private:
  ObserverLog();
  ~ObserverLog();
  int count;                                   // number to reference each actor in this framework
  std::map<void*,std::string> names;           // List of names assigned to actors
  std::set<void*> observables;                 // List of pointers to Observables. Needed to distinguish Observers and Observables
  void addName(void*, std::string);            // Assign a name to an Actor
  void addObservable(void*);
  void deleteName(void*);                      // delete the name of an Actor
  void deleteObservable(void*);
  boost::shared_ptr<ObserverLog::Log> addMessage(int depth=0);       // Add a Message to the logging
  std::stringstream log;
  static std::ostream *nullstream;             // stream that is not displayed
  static std::ostream *outstream;              // stream that is currently used
};

ObserverLog &observerLog();

template <class T>
boost::shared_ptr<ObserverLog::Log> operator<<(boost::shared_ptr<ObserverLog::Log> L, const T msg)
{
  L->log << msg;
  return L;
}

#endif /* OBSERVERLOG_HPP_ */
