/*
 * AtomSet_impl.hpp
 *
 *  Created on: Jul 8, 2010
 *      Author: crueger
 */

#ifndef OBSERVEDCONTAINER_IMPL_HPP_
#define OBSERVEDCONTAINER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Observer/ObservedContainer.hpp"

template <class Container>
inline ObservedContainer<Container>::ObservedContainer(Observable* _obs) :
  obs(_obs)
{}

template <class Container>
inline ObservedContainer<Container>::ObservedContainer(const ObservedContainer<Container> &src) :
  content(src.content),
  obs(src.obs)
{}

template <class Container>
inline ObservedContainer<Container>::~ObservedContainer()
{}

template <class Container>
inline
ObservedContainer<Container>&
ObservedContainer<Container>::operator=(const ObservedContainer<Container> &rhs){
  content=rhs.content;
  return *this;
}

template <class Container>
inline
typename ObservedContainer<Container>::iterator
ObservedContainer<Container>::begin(){
  return ObservedContainer<Container>::iterator(content.begin(),obs);
}

template <class Container>
inline
typename ObservedContainer<Container>::const_iterator
ObservedContainer<Container>::begin() const{
  return content.begin();
}

template <class Container>
inline
typename ObservedContainer<Container>::iterator
ObservedContainer<Container>::end(){
  return ObservedContainer<Container>::iterator(content.end(),obs);
}

template <class Container>
inline
typename ObservedContainer<Container>::const_iterator
ObservedContainer<Container>::end() const{
  return content.end();
}

template <class Container>
inline
typename ObservedContainer<Container>::reverse_iterator
ObservedContainer<Container>::rbegin(){
  return reverse_iterator(end());
}

template <class Container>
inline
typename ObservedContainer<Container>::const_reverse_iterator
ObservedContainer<Container>::rbegin() const{
  return const_reverse_iterator(end());
}

template <class Container>
inline
typename ObservedContainer<Container>::reverse_iterator
ObservedContainer<Container>::rend(){
  return reverse_iterator(begin());
}

template <class Container>
inline
typename ObservedContainer<Container>::const_reverse_iterator
ObservedContainer<Container>::rend() const{
  return const_reverse_iterator(begin());
}

template <class Container>
inline bool ObservedContainer<Container>::empty() const{
  return content.empty();
}

template <class Container>
inline size_t ObservedContainer<Container>::size() const{
  return content.size();
}

template <class Container>
inline size_t ObservedContainer<Container>::max_size() const{
  return content.max_size();
}

template <class Container>
inline
typename ObservedContainer<Container>::mapped_type &
ObservedContainer<Container>::operator[](const key_type &key){
  return content[key];
}

template <class Container>
inline
std::pair<typename ObservedContainer<Container>::iterator,bool>
ObservedContainer<Container>::insert (const value_type &value){
  std::pair<typename set_t::iterator,bool> res = content.insert(value);
  return std::make_pair(iterator(res.first,obs),res.second);
}

template <class Container>
inline size_t ObservedContainer<Container>::erase ( const key_type& x ){
  return content.erase(x);
}

template <class Container>
inline void ObservedContainer<Container>::clear(){
  content.clear();
}

template <class Container>
inline
typename ObservedContainer<Container>::iterator
ObservedContainer<Container>::find ( const key_type& x ){
  return iterator(content.find(x),obs);
}

template <class Container>
inline
typename ObservedContainer<Container>::const_iterator
ObservedContainer<Container>::find ( const key_type& x ) const{
  return content.find(x);
}

template <class Container>
inline size_t ObservedContainer<Container>::count ( const key_type& x ) const{
  return content.count(x);
}

/************ Unprotected access ***************/

template <class Container>
inline
typename ObservedContainer<Container>::internal_iterator
ObservedContainer<Container>::begin_internal(){
  return content.begin();
}

template <class Container>
inline
typename ObservedContainer<Container>::internal_iterator
ObservedContainer<Container>::end_internal(){
  return content.end();
}

template <class Container>
inline
typename ObservedContainer<Container>::reverse_internal_iterator
ObservedContainer<Container>::rbegin_internal(){
  return content.rbegin();
}

template <class Container>
inline
typename ObservedContainer<Container>::reverse_internal_iterator
ObservedContainer<Container>::rend_internal(){
  return content.rend();
}

template <class Container>
inline
typename ObservedContainer<Container>::set_t &
ObservedContainer<Container>::getContent(){
  return content;
}

/************ Explicit instantiation ***************/

#define CONSTRUCT_OBSERVEDCONTAINER(name) \
    template ObservedContainer< name >& ObservedContainer< name >::operator=(const ObservedContainer< name >&); \
    template ObservedContainer< name >::iterator ObservedContainer< name >::begin(); \
    template ObservedContainer< name >::const_iterator ObservedContainer< name >::begin() const; \
    template ObservedContainer< name >::iterator ObservedContainer< name >::end(); \
    template ObservedContainer< name >::const_iterator ObservedContainer< name >::end() const; \
    template ObservedContainer< name >::reverse_iterator ObservedContainer< name >::rbegin(); \
    template ObservedContainer< name >::const_reverse_iterator ObservedContainer< name >::rbegin() const; \
    template ObservedContainer< name >::reverse_iterator ObservedContainer< name >::rend(); \
    template ObservedContainer< name >::const_reverse_iterator ObservedContainer< name >::rend() const; \
    template bool ObservedContainer< name >::empty() const; \
    template size_t ObservedContainer< name >::size() const; \
    template size_t ObservedContainer< name >::max_size() const; \
    template ObservedContainer< name >::mapped_type &ObservedContainer< name >::operator[](const key_type&); \
    template std::pair<ObservedContainer< name >::iterator,bool> ObservedContainer< name >::insert (const value_type&); \
    template size_t ObservedContainer< name >::erase ( const key_type& x ); \
    template void ObservedContainer< name >::clear(); \
    template ObservedContainer< name >::iterator ObservedContainer< name >::find ( const key_type& x ); \
    template ObservedContainer< name >::const_iterator ObservedContainer< name >::find ( const key_type& x ) const; \
    template size_t ObservedContainer< name >::count ( const key_type& x ) const; \
    template ObservedContainer< name >::internal_iterator ObservedContainer< name >::begin_internal(); \
    template ObservedContainer< name >::reverse_internal_iterator ObservedContainer< name >::rbegin_internal(); \
    template ObservedContainer< name >::internal_iterator ObservedContainer< name >::end_internal(); \
    template ObservedContainer< name >::reverse_internal_iterator ObservedContainer< name >::rend_internal(); \

#endif /* OBSERVEDCONTAINER_IMPL_HPP_ */
