/*
 * log.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#ifndef LOG_HPP_
#define LOG_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/errorlogger.hpp"
#include "CodePatterns/logger.hpp"
#include "CodePatterns/Verbose.hpp"

#define LOG(level,msg) DoLog(level) && (Log() << Verbose(level) << msg << std::endl)
#define ELOG(level,msg) DoeLog(level) && (eLog() << Verbose(level) << msg << std::endl)

class logger & Log();
class errorLogger & eLog();
void setVerbosity(int verbosityLevel);
int getVerbosity();
bool DoLog(int verbose);
bool DoeLog(int verbose);

#endif /* LOG_HPP_ */
