/*
 * QtWorldView.hpp
 *
 *  Created on: Jan 21, 2010
 *      Author: crueger
 */

#ifndef QTMOLECULESVIEW_HPP_
#define QTMOLECULESVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include "CodePatterns/Observer/Observer.hpp"

class molecule;
class MoleculeListClass;

class QtWorldView : public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtWorldView(QWidget * _parent=0);
  virtual ~QtWorldView();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);
  virtual void paintEvent(QPaintEvent * event);
  void refill();

  static const int COLUMNCOUNT;
  enum {NAME,ATOMCOUNT,FORMULA,OCCURRENCE,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void moleculeChanged();

  void rowSelected();

signals:
  void moleculeSelected(molecule*);
  void moleculeUnSelected(molecule*);

private:
  std::vector<bool> molSelection; //!< needed to determine when a selection changes
  MoleculeListClass *molecules;
  bool dirty;
  bool clearing;
};

#endif /* QTMOLECULESVIEW_HPP_ */
