/*
 * AnalysisCorrelationToPointUnitTest.hpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

#ifndef ANALYSISCORRELATIONTOPOINTUNITTEST_HPP_
#define ANALYSISCORRELATIONTOPOINTUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class element;
class molecule;
class MoleculeListClass;
class Vector;

/********************************************** Test classes **************************************/

class AnalysisCorrelationToPointUnitTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisCorrelationToPointUnitTest ) ;
    CPPUNIT_TEST ( CorrelationToPointTest );
    CPPUNIT_TEST ( CorrelationToPointBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToPointBinRangeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void CorrelationToPointTest();
      void CorrelationToPointBinNoRangeTest();
      void CorrelationToPointBinRangeTest();

private:

      std::vector<const molecule *> allMolecules;
      molecule *TestMolecule;
      const element *hydrogen;

      CorrelationToPointMap *pointmap;
      BinPairMap *binmap;
      Vector *point;
};

#endif /* ANALYSISCORRELATIONTOPOINTUNITTEST_HPP_ */
