/*
 * ShapeUnittest.cpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#include "ShapeUnittest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "Shapes/Shape.hpp"
#include "vector.cpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ShapeUnittest );

void ShapeUnittest::setUp()
{
  v000 =  0*e1+0*e2+0*e3;
  v100 =  1*e1+0*e2+0*e3;
  v200 = -1*e1+0*e2+0*e3;
  v010 =  0*e1+1*e2+0*e3;
  v110 =  1*e1+1*e2+0*e3;
  v210 = -1*e1+1*e2+0*e3;
  v020 =  0*e1-1*e2+0*e3;
  v120 =  1*e1-1*e2+0*e3;
  v220 = -1*e1-1*e2+0*e3;
  v001 =  0*e1+0*e2+1*e3;
  v101 =  1*e1+0*e2+1*e3;
  v201 = -1*e1+0*e2+1*e3;
  v011 =  0*e1+1*e2+1*e3;
  v111 =  1*e1+1*e2+1*e3;
  v211 = -1*e1+1*e2+1*e3;
  v021 =  0*e1-1*e2+1*e3;
  v121 =  1*e1-1*e2+1*e3;
  v221 = -1*e1-1*e2+1*e3;
  v002 =  0*e1+0*e2-1*e3;
  v102 =  1*e1+0*e2-1*e3;
  v202 = -1*e1+0*e2-1*e3;
  v012 =  0*e1+1*e2-1*e3;
  v112 =  1*e1+1*e2-1*e3;
  v212 = -1*e1+1*e2-1*e3;
  v022 =  0*e1-1*e2-1*e3;
  v122 =  1*e1-1*e2-1*e3;
  v222 = -1*e1-1*e2-1*e3;
}

void ShapeUnittest::tearDown()
{}


void ShapeUnittest::baseShapesTest(){
  CPPUNIT_ASSERT(!Nowhere().isInside(v000));
  CPPUNIT_ASSERT(!Nowhere().isInside(v100));
  CPPUNIT_ASSERT(!Nowhere().isInside(v200));
  CPPUNIT_ASSERT(!Nowhere().isInside(v010));
  CPPUNIT_ASSERT(!Nowhere().isInside(v110));
  CPPUNIT_ASSERT(!Nowhere().isInside(v210));
  CPPUNIT_ASSERT(!Nowhere().isInside(v020));
  CPPUNIT_ASSERT(!Nowhere().isInside(v120));
  CPPUNIT_ASSERT(!Nowhere().isInside(v220));
  CPPUNIT_ASSERT(!Nowhere().isInside(v001));
  CPPUNIT_ASSERT(!Nowhere().isInside(v101));
  CPPUNIT_ASSERT(!Nowhere().isInside(v201));
  CPPUNIT_ASSERT(!Nowhere().isInside(v011));
  CPPUNIT_ASSERT(!Nowhere().isInside(v111));
  CPPUNIT_ASSERT(!Nowhere().isInside(v211));
  CPPUNIT_ASSERT(!Nowhere().isInside(v021));
  CPPUNIT_ASSERT(!Nowhere().isInside(v121));
  CPPUNIT_ASSERT(!Nowhere().isInside(v221));
  CPPUNIT_ASSERT(!Nowhere().isInside(v002));
  CPPUNIT_ASSERT(!Nowhere().isInside(v102));
  CPPUNIT_ASSERT(!Nowhere().isInside(v202));
  CPPUNIT_ASSERT(!Nowhere().isInside(v012));
  CPPUNIT_ASSERT(!Nowhere().isInside(v112));
  CPPUNIT_ASSERT(!Nowhere().isInside(v212));
  CPPUNIT_ASSERT(!Nowhere().isInside(v022));
  CPPUNIT_ASSERT(!Nowhere().isInside(v122));
  CPPUNIT_ASSERT(!Nowhere().isInside(v222));

  CPPUNIT_ASSERT(Everywhere().isInside(v000));
  CPPUNIT_ASSERT(Everywhere().isInside(v100));
  CPPUNIT_ASSERT(Everywhere().isInside(v200));
  CPPUNIT_ASSERT(Everywhere().isInside(v010));
  CPPUNIT_ASSERT(Everywhere().isInside(v110));
  CPPUNIT_ASSERT(Everywhere().isInside(v210));
  CPPUNIT_ASSERT(Everywhere().isInside(v020));
  CPPUNIT_ASSERT(Everywhere().isInside(v120));
  CPPUNIT_ASSERT(Everywhere().isInside(v220));
  CPPUNIT_ASSERT(Everywhere().isInside(v001));
  CPPUNIT_ASSERT(Everywhere().isInside(v101));
  CPPUNIT_ASSERT(Everywhere().isInside(v201));
  CPPUNIT_ASSERT(Everywhere().isInside(v011));
  CPPUNIT_ASSERT(Everywhere().isInside(v111));
  CPPUNIT_ASSERT(Everywhere().isInside(v211));
  CPPUNIT_ASSERT(Everywhere().isInside(v021));
  CPPUNIT_ASSERT(Everywhere().isInside(v121));
  CPPUNIT_ASSERT(Everywhere().isInside(v221));
  CPPUNIT_ASSERT(Everywhere().isInside(v002));
  CPPUNIT_ASSERT(Everywhere().isInside(v102));
  CPPUNIT_ASSERT(Everywhere().isInside(v202));
  CPPUNIT_ASSERT(Everywhere().isInside(v012));
  CPPUNIT_ASSERT(Everywhere().isInside(v112));
  CPPUNIT_ASSERT(Everywhere().isInside(v212));
  CPPUNIT_ASSERT(Everywhere().isInside(v022));
  CPPUNIT_ASSERT(Everywhere().isInside(v122));
  CPPUNIT_ASSERT(Everywhere().isInside(v222));
}

void ShapeUnittest::assignmentTest(){
  Shape s1 = Nowhere();
  s1 = Everywhere();

  CPPUNIT_ASSERT(s1.isInside(v000));
  CPPUNIT_ASSERT(s1.isInside(v100));
  CPPUNIT_ASSERT(s1.isInside(v200));
  CPPUNIT_ASSERT(s1.isInside(v010));
  CPPUNIT_ASSERT(s1.isInside(v110));
  CPPUNIT_ASSERT(s1.isInside(v210));
  CPPUNIT_ASSERT(s1.isInside(v020));
  CPPUNIT_ASSERT(s1.isInside(v120));
  CPPUNIT_ASSERT(s1.isInside(v220));
  CPPUNIT_ASSERT(s1.isInside(v001));
  CPPUNIT_ASSERT(s1.isInside(v101));
  CPPUNIT_ASSERT(s1.isInside(v201));
  CPPUNIT_ASSERT(s1.isInside(v011));
  CPPUNIT_ASSERT(s1.isInside(v111));
  CPPUNIT_ASSERT(s1.isInside(v211));
  CPPUNIT_ASSERT(s1.isInside(v021));
  CPPUNIT_ASSERT(s1.isInside(v121));
  CPPUNIT_ASSERT(s1.isInside(v221));
  CPPUNIT_ASSERT(s1.isInside(v002));
  CPPUNIT_ASSERT(s1.isInside(v102));
  CPPUNIT_ASSERT(s1.isInside(v202));
  CPPUNIT_ASSERT(s1.isInside(v012));
  CPPUNIT_ASSERT(s1.isInside(v112));
  CPPUNIT_ASSERT(s1.isInside(v212));
  CPPUNIT_ASSERT(s1.isInside(v022));
  CPPUNIT_ASSERT(s1.isInside(v122));
  CPPUNIT_ASSERT(s1.isInside(v222));

  Shape s2 = Everywhere();
  s2 = Nowhere();

  CPPUNIT_ASSERT(!s2.isInside(v000));
  CPPUNIT_ASSERT(!s2.isInside(v100));
  CPPUNIT_ASSERT(!s2.isInside(v200));
  CPPUNIT_ASSERT(!s2.isInside(v010));
  CPPUNIT_ASSERT(!s2.isInside(v110));
  CPPUNIT_ASSERT(!s2.isInside(v210));
  CPPUNIT_ASSERT(!s2.isInside(v020));
  CPPUNIT_ASSERT(!s2.isInside(v120));
  CPPUNIT_ASSERT(!s2.isInside(v220));
  CPPUNIT_ASSERT(!s2.isInside(v001));
  CPPUNIT_ASSERT(!s2.isInside(v101));
  CPPUNIT_ASSERT(!s2.isInside(v201));
  CPPUNIT_ASSERT(!s2.isInside(v011));
  CPPUNIT_ASSERT(!s2.isInside(v111));
  CPPUNIT_ASSERT(!s2.isInside(v211));
  CPPUNIT_ASSERT(!s2.isInside(v021));
  CPPUNIT_ASSERT(!s2.isInside(v121));
  CPPUNIT_ASSERT(!s2.isInside(v221));
  CPPUNIT_ASSERT(!s2.isInside(v002));
  CPPUNIT_ASSERT(!s2.isInside(v102));
  CPPUNIT_ASSERT(!s2.isInside(v202));
  CPPUNIT_ASSERT(!s2.isInside(v012));
  CPPUNIT_ASSERT(!s2.isInside(v112));
  CPPUNIT_ASSERT(!s2.isInside(v212));
  CPPUNIT_ASSERT(!s2.isInside(v022));
  CPPUNIT_ASSERT(!s2.isInside(v122));
  CPPUNIT_ASSERT(!s2.isInside(v222));

}
void ShapeUnittest::operatorTest(){
  {
    Shape s1 = !Nowhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = !Everywhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

  {
    Shape s1 = Nowhere() || Everywhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = Nowhere() && Everywhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

  {
    Shape s1 = Everywhere() || Nowhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = Everywhere() && Nowhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

}
