#!/usr/bin/tclsh
#
# This scripts parses a series of tecplot style files of triangles and displays them via VMD's graphics interface

# fname is the filename prefix of the tecplot .dat files, e.g. "convex" for "convex-0.dat"
proc convexizing { fname steps} {
	global framesteps
	global fileprefix
	set framesteps $steps
	set fileprefix $fname

	# avoid some 'animate dup' bug
	set molid [molinfo top]
	if {$steps < 2} {
		error "steps should be greater than 2."
	}
	# make tcount-1 copies of current frame
	for {set i 0} {$i <$steps} {incr i} {
		animate dup frame 0 $molid
	}
	animate goto 0

	global vmd_frame
	trace variable vmd_frame([molinfo top]) w update_current_surface
	display update
	return
}	

proc update_current_surface {name index op} { 
	global fileprefix

	draw delete all
	set frame [molinfo $index get frame]
	# open file
	set fname "$fileprefix-$frame.dat"
	#puts "Opening new file $fname."
	set file [open $fname r]
	gets $file title
	gets $file variables
	gets $file zone
	# parse nodes
	set ncount 1
	gets $file line
	while { $line != {} } {
		set nodes($ncount) $line
		incr ncount
		gets $file line
	}
	set ncount [ expr $ncount -1 ]
	# there's a blank line in between
	# parse triangles
	set tcount 0
	gets $file line
	while { $line != {} } {
		set triangles [ split $line " "]
		set first [ lrange $nodes([ lindex $triangles 0 ]) 0 2 ]
		set second [ lrange $nodes([ lindex $triangles 1 ]) 0 2 ]
		set third [ lrange $nodes([ lindex $triangles 2 ]) 0 2 ]
		draw color blue
		draw material Transparent
		draw triangle $first $second $third
		incr tcount
		gets $file line
	}
	close $file
	#puts "There are $tcount triangles."
	
	return
}

proc convexizing_off {} {
	global vmd_frame
	global framesteps
	trace vdelete vmd_frame([molinfo top]) w update_current_surface
	draw delete all
	animate delete beg 1 end $framesteps skip 0 [molinfo top]
	return
}

