/*
 * QtObservedMolecule.hpp
 *
 *  Created on: Oct 28, 2015
 *      Author: heber
 */


#ifndef QTOBSERVEDMOLECULE_HPP_
#define QTOBSERVEDMOLECULE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QWidget>

#include <boost/shared_ptr.hpp>

#include "CodePatterns/Observer/Observer.hpp"

#include "UIElements/Qt4/InstanceBoard/ObservedValue_types.hpp"
#include "types.hpp"

class QtObservedInstanceBoard;

/** This instance is the ObservedValue representation of a World's molecule.
 *
 * Due to the signal/slot mechanism and its delays, lifetime of objects in the
 * World and their QtGui representation cannot directly be related (without
 * slowing down Actions just for having the representation up to speed).
 * Hence, the required information for displaying and representing these
 * objects must be contained in an extra instance.
 *
 * This is the instance for information about a particular molecule.
 */
class QtObservedMolecule : public QWidget, public Observer
{
  Q_OBJECT

  //!> QtObservedInstanceBoard needs to access private cstor and dstor
  friend class QtObservedInstanceBoard;

  //!> typedef for instance wrapped in shared ptr
  typedef boost::shared_ptr<QtObservedMolecule> ptr;

  /** Cstor of QtObservedMolecule.
   *
   * \param _obsvalues ref to set of observed values for this instance
   * \param _parent Qt parent to automatically destroy when parent is destroyed
   */
  QtObservedMolecule(
      const ObservedValues_t &_obsvalues,
      QWidget * _parent=0);

public:

  /** Dstor of QtObservedMolecule.
   *
   */
  ~QtObservedMolecule();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

signals:

private slots:


private:
  //!> internal reference to ObservedValues held by QtObservedInstanceBoard
  const ObservedValues_t &obsvalues;
};


#endif /* QTOBSERVEDMOLECULE_HPP_ */
