/*
 * PrincipalAxisSystemAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Actions/AnalysisAction/PrincipalAxisSystemAction.hpp"
#include "CommandLineParser.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPrincipalAxisSystemAction::NAME[] = "principal-axis-system";

AnalysisPrincipalAxisSystemAction::AnalysisPrincipalAxisSystemAction() :
  Action(NAME)
{}

AnalysisPrincipalAxisSystemAction::~AnalysisPrincipalAxisSystemAction()
{}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Evaluating prinicipal axis." << endl);
    mol->PrincipalAxisSystem(false);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AnalysisPrincipalAxisSystemAction::canUndo() {
  return false;
}

bool AnalysisPrincipalAxisSystemAction::shouldUndo() {
  return false;
}

const string AnalysisPrincipalAxisSystemAction::getName() {
  return NAME;
}
