/*
 * PairCorrelationToSurfaceAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/AnalysisAction/PairCorrelationToSurfaceAction.hpp"
#include "CommandLineParser.hpp"
#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "element.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPairCorrelationToSurfaceAction::NAME[] = "pair-correlation-surface";

AnalysisPairCorrelationToSurfaceAction::AnalysisPairCorrelationToSurfaceAction() :
  Action(NAME)
{}

AnalysisPairCorrelationToSurfaceAction::~AnalysisPairCorrelationToSurfaceAction()
{}

Action::state_ptr AnalysisPairCorrelationToSurfaceAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  double BinStart = 0.;
  double BinWidth = 0.;
  double BinEnd = 0.;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  int ranges[3] = {1, 1, 1};
  const element *elemental = NULL;
  molecule *Boundary = NULL;

  dialog->queryElement("elements", &elemental, MapOfActions::getInstance().getDescription("element"));
  dialog->queryMolecule("molecule-by-id", &Boundary, MapOfActions::getInstance().getDescription("molecule-by-id"));
  dialog->queryDouble("bin-start", &BinStart, MapOfActions::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-end", &BinEnd, MapOfActions::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", &outputname, MapOfActions::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", &binoutputname, MapOfActions::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", &periodic, MapOfActions::getInstance().getDescription("periodic"));

  if(dialog->display()) {
    output.open(outputname.c_str());
    binoutput.open(binoutputname.c_str());
    const double radius = 4.;
    double LCWidth = 20.;
    if (BinEnd > 0) {
      if (BinEnd > 2.*radius)
          LCWidth = BinEnd;
      else
        LCWidth = 2.*radius;
    }
    class MoleculeListClass *molecules = World::getInstance().getMolecules();
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    LCList = new LinkedCell(Boundary, LCWidth);
    FindNonConvexBorder(Boundary, TesselStruct, LCList, radius, NULL);
    CorrelationToSurfaceMap *surfacemap = NULL;
    if (periodic)
      surfacemap = PeriodicCorrelationToSurface( molecules, elemental, TesselStruct, LCList, ranges);
    else
      surfacemap = CorrelationToSurface( molecules, elemental, TesselStruct, LCList);
    OutputCorrelationToSurface(&output, surfacemap);
    // check whether radius was appropriate
    {
      double start; double end;
      GetMinMax( surfacemap, start, end);
      if (LCWidth < end)
        DoeLog(1) && (eLog()<< Verbose(1) << "Linked Cell width is smaller than the found range of values! Bins can only be correct up to: " << radius << "." << endl);
    }
    BinPairMap *binmap = BinData( surfacemap, BinWidth, BinStart, BinEnd );
    OutputCorrelation ( &binoutput, binmap );
    output.close();
    binoutput.close();
    delete(LCList);
    delete(TesselStruct);
    delete(binmap);
    delete(surfacemap);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr AnalysisPairCorrelationToSurfaceAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AnalysisPairCorrelationToSurfaceAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AnalysisPairCorrelationToSurfaceAction::canUndo() {
  return false;
}

bool AnalysisPairCorrelationToSurfaceAction::shouldUndo() {
  return false;
}

const string AnalysisPairCorrelationToSurfaceAction::getName() {
  return NAME;
}
