/*
 * PairCorrelationToPointAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/AnalysisAction/PairCorrelationToPointAction.hpp"
#include "CommandLineParser.hpp"
#include "analysis_correlation.hpp"
#include "log.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPairCorrelationToPointAction::NAME[] = "pair-correlation-point";

AnalysisPairCorrelationToPointAction::AnalysisPairCorrelationToPointAction() :
  Action(NAME)
{}

AnalysisPairCorrelationToPointAction::~AnalysisPairCorrelationToPointAction()
{}

Action::state_ptr AnalysisPairCorrelationToPointAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  int ranges[3] = {1, 1, 1};
  Vector position;
  double BinStart = 0.;
  double BinEnd = 0.;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  const element *elemental;

  dialog->queryElement("elements", &elemental, MapOfActions::getInstance().getDescription("element"));
  dialog->queryVector("position", &position, World::getInstance().getDomain(), true, MapOfActions::getInstance().getDescription("position"));
  dialog->queryDouble("bin-start", &BinStart, MapOfActions::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-end", &BinEnd, MapOfActions::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", &outputname, MapOfActions::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", &binoutputname, MapOfActions::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", &periodic, MapOfActions::getInstance().getDescription("periodic"));

  if(dialog->display()) {
    output.open(outputname.c_str());
    binoutput.open(binoutputname.c_str());
    const Vector Point = position;
    CorrelationToPointMap *correlationmap = NULL;
    if (periodic)
      correlationmap  = PeriodicCorrelationToPoint(World::getInstance().getMolecules(), elemental, &Point, ranges);
    else
      correlationmap = CorrelationToPoint(World::getInstance().getMolecules(), elemental, &Point);
    //OutputCorrelationToSurface(&output, correlationmap);
    BinPairMap *binmap = BinData( correlationmap, 0.5, BinStart, BinEnd );
    OutputCorrelation ( &binoutput, binmap );
    output.close();
    binoutput.close();
    delete(binmap);
    delete(correlationmap);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr AnalysisPairCorrelationToPointAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AnalysisPairCorrelationToPointAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AnalysisPairCorrelationToPointAction::canUndo() {
  return false;
}

bool AnalysisPairCorrelationToPointAction::shouldUndo() {
  return false;
}

const string AnalysisPairCorrelationToPointAction::getName() {
  return NAME;
}
