/*
 * PairCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/AnalysisAction/PairCorrelationAction.hpp"
#include "CommandLineParser.hpp"
#include "analysis_correlation.hpp"
#include "log.hpp"
#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPairCorrelationAction::NAME[] = "pair-correlation";

AnalysisPairCorrelationAction::AnalysisPairCorrelationAction() :
  Action(NAME)
{}

AnalysisPairCorrelationAction::~AnalysisPairCorrelationAction()
{}

Action::state_ptr AnalysisPairCorrelationAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  int ranges[3] = {1, 1, 1};
  double BinStart = 0.;
  double BinEnd = 0.;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  const element *elemental1;
  const element *elemental2;

  dialog->queryElement("elements", &elemental1, MapOfActions::getInstance().getDescription("elements"));
  dialog->queryElement("elements", &elemental2, MapOfActions::getInstance().getDescription("elements"));
  dialog->queryDouble("bin-start", &BinStart, MapOfActions::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-end", &BinEnd, MapOfActions::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", &outputname, MapOfActions::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", &binoutputname, MapOfActions::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", &periodic, MapOfActions::getInstance().getDescription("periodic"));

  if(dialog->display()) {
    output.open(outputname.c_str());
    binoutput.open(binoutputname.c_str());
    PairCorrelationMap *correlationmap = NULL;
    if (periodic)
      correlationmap = PeriodicPairCorrelation(World::getInstance().getMolecules(), elemental1, elemental2, ranges);
    else
      correlationmap = PairCorrelation(World::getInstance().getMolecules(), elemental1, elemental2);
    //OutputCorrelationToSurface(&output, correlationmap);
    BinPairMap *binmap = BinData( correlationmap, 0.5, BinStart, BinEnd );
    OutputCorrelation ( &binoutput, binmap );
    output.close();
    binoutput.close();
    delete(binmap);
    delete(correlationmap);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr AnalysisPairCorrelationAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AnalysisPairCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AnalysisPairCorrelationAction::canUndo() {
  return false;
}

bool AnalysisPairCorrelationAction::shouldUndo() {
  return false;
}

const string AnalysisPairCorrelationAction::getName() {
  return NAME;
}
