/*
 * DisplayMenuItem.cpp
 *
 *  Created on: Dec 14, 2009
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include <sstream>
#include <cmath>

#include "Menu/DisplayMenuItem.hpp"
#include "Views/StringView.hpp"


DisplayMenuItem::DisplayMenuItem(Menu* _menu, StringView *_view):
  MenuItem('\0',"",_menu),
  view(_view),
  title("")
{
}

DisplayMenuItem::DisplayMenuItem(Menu* _menu, StringView *_view, string _title, char _spacer, int _length ):
  MenuItem('\0',"",_menu),
  view(_view),
  title(_title),
  length(_length),
  spacer(_spacer)
{
}

DisplayMenuItem::~DisplayMenuItem()
{}


void DisplayMenuItem::doTrigger(){}
bool DisplayMenuItem::checkTrigger(char c){
  return false;
}

const string DisplayMenuItem::formatEntry(){
  stringstream s;
  if(title.length()>0) {
    int pre = floor((length-title.length())/2.0);
    int post = ceil((length-title.length())/2.0);
    for(int i=0;i<pre;i++)
      s << spacer;
    s << title;
    for(int i=0;i<post;i++)
          s << spacer;
    s << "\n";
  }
  s << view->toString();
  return s.str();
}


const string DisplayMenuItem::getDescription(){
  return string("");
}
