/*
 * QtUIFactory.hpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#ifndef QTUIFACTORY_HPP_
#define QTUIFACTORY_HPP_

#include "UIElements/UIFactory.hpp"

class QApplication;

class QtUIFactory : public UIFactory
{
  friend class UIFactory;

public:
  virtual ~QtUIFactory();

  virtual Dialog* makeDialog();
  virtual MainWindow* makeMainWindow();

  struct description : public UIFactory::factoryDescription {
    description();
    virtual ~description();

    virtual UIFactory* makeFactory();
  };

protected:
  QtUIFactory();

private:
  // faked command line arguments
  int argc;
  char **argv;
  QApplication *app;
};

#endif /* QTUIFACTORY_HPP_ */
