/*
 * QtDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>
#include <QtGui/QFileDialog>

#include <boost/filesystem.hpp>

#include <map>
#include <set>
#include <vector>

class QBoxLayout;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QListWidget;
class QTableWidget;
class QComboBox;
class QDialogButtonBox;

class Matrix;

// Forward declarations for plumbing
template<typename T> class QtQueryListPipe;
class BooleanQtQueryPipe;
class BoxQtQueryPipe;
class StringQtQueryPipe;
class StringsQtQueryPipe;
class IntQtQueryPipe;
class DoubleQtQueryPipe;
class DoublesQtQueryPipe;
class AtomQtQueryPipe;
class AtomsQtQueryPipe;
class MoleculeQtQueryPipe;
class MoleculesQtQueryPipe;
class EmptyQtQueryPipe;
class ElementQtQueryPipe;
class ElementsQtQueryPipe;
class VectorQtQueryPipe;
class VectorsQtQueryPipe;
class FileQtQueryPipe;

class QtDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QtDialog();
  virtual ~QtDialog();

  virtual void queryEmpty(const char*, std::string);
  virtual void queryBoolean(const char *, std::string = "");
  virtual void queryInt(const char *,std::string = "");
  virtual void queryInts(const char *,std::string = "");
  virtual void queryDouble(const char*,std::string = "");
  virtual void queryDoubles(const char*,std::string = "");
  virtual void queryString(const char*,std::string = "");
  virtual void queryStrings(const char*,std::string = "");
  virtual void queryAtom(const char*,std::string = "");
  virtual void queryAtoms(const char*,std::string = "");
  virtual void queryMolecule(const char*,std::string = "");
  virtual void queryMolecules(const char*,std::string = "");
  virtual void queryVector(const char*,bool,std::string = "");
  virtual void queryVectors(const char*,bool,std::string = "");
  virtual void queryBox(const char*, std::string = "");
  virtual void queryElement(const char*,std::string = "");
  virtual void queryElements(const char*,std::string = "");
  virtual void queryFile(const char*,std::string = "");

  virtual bool display();

  virtual void update();

protected:
  class IntQtQuery : public Dialog::IntQuery {
    public:
      IntQtQuery(std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~IntQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QSpinBox *inputBox;

      IntQtQueryPipe *pipe;
    };

  class IntsQtQuery : public Dialog::IntsQuery {
    public:
      IntsQtQuery(std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~IntsQtQuery();
      virtual bool handle();
      void IntegerEntered(const QString&);
      void IntegerSelected();
      void AddInteger();
      void RemoveInteger();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;

      QtQueryListPipe<int> *pipe;
    };

    class DoubleQtQuery : public Dialog::DoubleQuery {
    public:
      DoubleQtQuery(std::string title,QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~DoubleQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QDoubleSpinBox *inputBox;

      DoubleQtQueryPipe *pipe;
    };

    class DoublesQtQuery : public Dialog::DoublesQuery {
    public:
      DoublesQtQuery(std::string title,QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~DoublesQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QDoubleSpinBox *inputBox;

      QtQueryListPipe<double> *pipe;
    };

    class StringQtQuery : public Dialog::StringQuery {
    public:
      StringQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~StringQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      StringQtQueryPipe *pipe;
    };

    class StringsQtQuery : public Dialog::StringsQuery {
    public:
      StringsQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~StringsQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      QtQueryListPipe<std::string> *pipe;
    };

    class BoxQtQuery : public Dialog::BoxQuery {
    public:
      BoxQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~BoxQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QTableWidget *inputTable;

      BoxQtQueryPipe *pipe;
    };

    class AtomQtQuery : public Dialog::AtomQuery {
    public:
      AtomQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~AtomQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      AtomQtQueryPipe *pipe;
    };

    class AtomsQtQuery : public Dialog::AtomsQuery {
    public:
      AtomsQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~AtomsQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      AtomsQtQueryPipe *pipe;
    };

    class MoleculeQtQuery : public Dialog::MoleculeQuery {
    public:
      MoleculeQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~MoleculeQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      MoleculeQtQueryPipe *pipe;
    };

    class MoleculesQtQuery : public Dialog::MoleculesQuery {
    public:
      MoleculesQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
      virtual ~MoleculesQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      MoleculesQtQueryPipe *pipe;
    };

    class VectorQtQuery : public Dialog::VectorQuery {
    public:
      VectorQtQuery(std::string title,bool _check,QBoxLayout *,QtDialog *);
      virtual ~VectorQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *mainLayout;
      QLabel *titleLabel;
      QBoxLayout *subLayout;
      QBoxLayout *coordLayout;
      QLabel *coordLabel;
      QDoubleSpinBox *coordInput;

      VectorQtQueryPipe *pipe;
    };

    class VectorsQtQuery : public Dialog::VectorsQuery {
    public:
      VectorsQtQuery(std::string title,bool _check,QBoxLayout *,QtDialog *);
      virtual ~VectorsQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *mainLayout;
      QLabel *titleLabel;
      QBoxLayout *subLayout;
      QBoxLayout *coordLayout;
      QLabel *coordLabel;
      QDoubleSpinBox *coordInput;

      VectorsQtQueryPipe *pipe;
    };

    class EmptyQtQuery : public Dialog::EmptyQuery {
    public:
      EmptyQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
      virtual ~EmptyQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;

      EmptyQtQueryPipe *pipe;
    };

    class BooleanQtQuery : public Dialog::BooleanQuery {
    public:
      BooleanQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
      virtual ~BooleanQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *booleanComboBox;

      BooleanQtQueryPipe *pipe;
    };

    class ElementQtQuery : public Dialog::ElementQuery {
    public:
      ElementQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
      virtual ~ElementQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      ElementQtQueryPipe *pipe;
    };

    class ElementsQtQuery : public Dialog::ElementsQuery {
    public:
      ElementsQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
      virtual ~ElementsQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      ElementsQtQueryPipe *pipe;
    };

    class FileQtQuery : public Dialog::FileQuery {
    public:
      FileQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
      virtual ~FileQtQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *filenameLabel;
      QLineEdit *filenameLineEdit;
      QPushButton *filedialogButton;

      FileQtQueryPipe *pipe;
    };

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};

// All kinds of plumbing for Queries
// Plumbing needs to be outside of the class where it is needed,
// since MOC doesn't like nested classes


template<typename T> class QtQueryListPipe : public QWidget {
  public:
    QtQueryListPipe(std::vector<T> *_content, QtDialog *_dialog, QLineEdit *_inputBox, QListWidget *_inputList, QPushButton *_AddButton, QPushButton *_RemoveButton);
    virtual ~QtQueryListPipe();
    void AddInteger();
    void RemoveInteger();
    void IntegerSelected();
    void IntegerEntered(const QString&);

  private:
    void AddValue(T item);
    void RemoveRow(int row);

    std::vector<T> *content;
    QtDialog *dialog;
    QLineEdit *inputBox;
    QListWidget *inputList;
    QPushButton *AddButton;
    QPushButton *RemoveButton;
};


class StringQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  StringQtQueryPipe(std::string *_content, QtDialog *_dialog);
  virtual ~StringQtQueryPipe();

public slots:
  void update(const QString&);

private:
  std::string *content;
  QtDialog *dialog;

};

class IntQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  IntQtQueryPipe(int *_content, QtDialog *_dialog);
  virtual ~IntQtQueryPipe();

public slots:
  void update(int);

private:
  int *content;
  QtDialog *dialog;

};


class DoubleQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  DoubleQtQueryPipe(double *_content, QtDialog *_dialog);
  virtual ~DoubleQtQueryPipe();

public slots:
  void update(double);

private:
  double *content;
  QtDialog *dialog;

};

class BoxQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  BoxQtQueryPipe(Box &_content, QtDialog *_dialog, QTableWidget *_inputTable);
  virtual ~BoxQtQueryPipe();

public slots:
  void update(int,int);

private:
  Box &content;
  QtDialog *dialog;
  QTableWidget *inputTable;

  Matrix *tmpM;
};


class AtomQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  AtomQtQueryPipe(atom **_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~AtomQtQueryPipe();

public slots:
  void update(int);

private:
  atom **content;
  QtDialog *dialog;
  QComboBox *theBox;

};


class AtomsQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  AtomsQtQueryPipe(std::vector<atom *>*_content, QtDialog *_dialog, QListWidget *_theList);
  virtual ~AtomsQtQueryPipe();

public slots:
  void update();
  void add();
  void remove();

private:
  std::vector<atom *>*content;
  std::map<int, atom *> lookup;
  std::set<atom *> currentList;
  QtDialog *dialog;
  QListWidget *theList;

};

class MoleculeQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  MoleculeQtQueryPipe(molecule **_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~MoleculeQtQueryPipe();

public slots:
  void update(int);

private:
  molecule **content;
  QtDialog *dialog;
  QComboBox *theBox;

};

class MoleculesQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  MoleculesQtQueryPipe(std::vector<molecule *>*_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~MoleculesQtQueryPipe();

public slots:
  void update(int);

private:
  std::vector<molecule *>*content;
  QtDialog *dialog;
  QComboBox *theBox;

};

class VectorQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  VectorQtQueryPipe(Vector *_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~VectorQtQueryPipe();

public slots:
  void update();

private:
  Vector *content;
  QtDialog *dialog;
  QComboBox *theBox;
};

class VectorsQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  VectorsQtQueryPipe(std::vector<Vector>*_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~VectorsQtQueryPipe();

public slots:
  void update();

private:
  std::vector<Vector> *content;
  QtDialog *dialog;
  QComboBox *theBox;
};

class EmptyQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  EmptyQtQueryPipe(QtDialog *_dialog, QLabel *_textLabel);
  virtual ~EmptyQtQueryPipe();

public slots:
  void update();

private:
  QtDialog *dialog;
  QLabel *textLabel;
};

class BooleanQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  BooleanQtQueryPipe(const bool *_content, QtDialog *_dialog, QComboBox *_booleanComboBox);
  virtual ~BooleanQtQueryPipe();

public slots:
  void update();

private:
  const bool *content;
  QtDialog *dialog;
  QComboBox *booleanComboBox;
};

class ElementQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  ElementQtQueryPipe(const element **_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~ElementQtQueryPipe();

public slots:
  void update(int);

private:
  const element **content;
  QtDialog *dialog;
  QComboBox *theBox;
};

class ElementsQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  ElementsQtQueryPipe(std::vector<const element *>*_content, QtDialog *_dialog, QComboBox *_theBox);
  virtual ~ElementsQtQueryPipe();

public slots:
  void update(int);

private:
  std::vector<const element *>*content;
  QtDialog *dialog;
  QComboBox *theBox;
};

class FileQtQueryPipe : public QWidget {
  Q_OBJECT
public:
  FileQtQueryPipe(boost::filesystem::path *_content, QtDialog *_dialog, QLineEdit *_filenameLineEdit, QPushButton *_filedialogButton);
  virtual ~FileQtQueryPipe();

public slots:
  void update();
  void showFileDialog();

private:
  boost::filesystem::path *content;
  QtDialog *dialog;
  QLineEdit *filenameLineEdit;
  QPushButton *filedialogButton;
  QFileDialog *theFileDialog;
};

#endif /* QTDIALOG_HPP_ */
