/*
 * GlobalListOfActions.hpp
 *
 *  Created on: Sep 21, 2011
 *      Author: heber
 */

#ifndef GLOBALLISTOFACTIONS_HPP_
#define GLOBALLISTOFACTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/seq/push_back.hpp>
#include <boost/preprocessor/seq/remove.hpp>

// this is global list of actions valid for all cases
#define GLOBALLISTOFACTIONS_initial \
  (Redo) \
  (GraphUpdateMolecules) \
  (GraphCreateAdjacency) \
  (GraphDepthFirstSearch) \
  (GraphDestroyAdjacency) \
  (GraphSubgraphDissection) \
  (MoleculeSaveTemperature) \
  (MoleculeCopy) \
  (MoleculeSuspendInWater) \
  (MoleculeFillWithMolecule) \
  (MoleculeRotateToPrincipalAxisSystem) \
  (MoleculeSaveAdjacency) \
  (MoleculeFillVoidWithMolecule) \
  (MoleculeVerletIntegration) \
  (MoleculeChangeName) \
  (MoleculeChangeBondAngle) \
  (MoleculeRotateAroundSelfByAngle) \
  (MoleculeSaveSelectedMolecules) \
  (MoleculeSaveBonds) \
  (MoleculeStretchBond) \
  (MoleculeLinearInterpolationofTrajectories) \
  (MoleculeLoad) \
  (MoleculeBondFile) \
  (TesselationNonConvexEnvelope) \
  (TesselationConvexEnvelope) \
  (CommandElementDb) \
  (CommandBondLengthTable) \
  (CommandFastParsing) \
  (CommandHelp) \
  (CommandHelpRedistribute) \
  (CommandSetRandomNumbersEngine) \
  (CommandSetRandomNumbersDistribution) \
  (CommandStoreSession) \
  (CommandVerbose) \
  (CommandVersion) \
  (CommandWarranty) \
  (ParserSetTremoloAtomdata) \
  (ParserParseTremoloPotentials) \
  (ParserSaveSelectedAtomsAsExtTypes) \
  (ParserSetParserParameters) \
  (ParserSetOutputFormats) \
  (AnalysisDipoleAngularCorrelation) \
  (AnalysisDipoleCorrelation) \
  (AnalysisPairCorrelation) \
  (AnalysisPointCorrelation) \
  (AnalysisSurfaceCorrelation) \
  (AnalysisMolecularVolume) \
  (AnalysisPrincipalAxisSystem) \
  (Undo) \
  (AtomSaveSelectedAtoms) \
  (AtomRotateAroundOriginByAngle) \
  (AtomChangeElement) \
  (AtomRemove) \
  (AtomTranslate) \
  (AtomAdd) \
  (BondAdd) \
  (BondRemove) \
  (WorldCenterInBox) \
  (WorldRepeatBox) \
  (WorldChangeBox) \
  (WorldCenterOnEdge) \
  (WorldSetWorldTime) \
  (WorldSetBoundaryConditions) \
  (WorldOutput) \
  (WorldOutputAs) \
  (WorldSetDefaultName) \
  (WorldScaleBox) \
  (WorldAddEmptyBoundary) \
  (WorldBoundInBox) \
  (WorldInput) \
  (SelectionNotMoleculeOfAtom) \
  (SelectionNotAllMolecules) \
  (SelectionNotMoleculeById) \
  (SelectionMoleculeByOrder) \
  (SelectionMoleculeOfAtom) \
  (SelectionNotMoleculeByOrder) \
  (SelectionMoleculeByName) \
  (SelectionMoleculeById) \
  (SelectionAllMolecules) \
  (SelectionClearAllMolecules) \
  (SelectionInvertMolecules) \
  (SelectionMoleculeByFormula) \
  (SelectionNotMoleculeByFormula) \
  (SelectionNotMoleculeByName) \
  (SelectionNotAtomById) \
  (SelectionNotAtomByOrder) \
  (SelectionAllAtoms) \
  (SelectionClearAllAtoms) \
  (SelectionInvertAtoms) \
  (SelectionNotAllAtoms) \
  (SelectionNotAtomByElement) \
  (SelectionAllAtomsInsideVolume) \
  (SelectionAllAtomsOfMolecule) \
  (SelectionNotAllAtomsInsideVolume) \
  (SelectionAtomByElement) \
  (SelectionNotAllAtomsOfMolecule) \
  (SelectionAtomById) \
  (SelectionAtomByOrder) \
  (SelectionAllShapes) \
  (SelectionShapeByName) \
  (SelectionNotAllShapes) \
  (SelectionNotShapeByName) \
  (FragmentationAnalyseFragmentationResults) \
  (FragmentationClearFragmentationResults) \
  (FragmentationFragmentation) \
  (FragmentationStoreSaturatedFragment) \
  (PotentialFitParticleCharges) \
  (PotentialParseHomologies) \
  (PotentialSaveHomologies) \
  (FillRegularGrid) \
  (FillSurface) \
  (ShapeCombineShapes) \
  (ShapeCreateShape) \
  (ShapeRemoveShape) \
  (ShapeRotateShape) \
  (ShapeStretchShape) \
  (ShapeTranslateShape)

// we need to append the automation action in case we have the JobMarket
#ifdef HAVE_JOBMARKET
#define GLOBALLISTOFACTIONS_JOBMARKET \
    BOOST_PP_SEQ_PUSH_BACK( \
        BOOST_PP_SEQ_PUSH_BACK( \
            BOOST_PP_SEQ_PUSH_BACK( \
                GLOBALLISTOFACTIONS_initial, \
                FragmentationFragmentationAutomation \
            ), \
            FragmentationMolecularDynamics \
        ), \
        FragmentationParseFragmentJobs \
    )
#else
#define GLOBALLISTOFACTIONS_JOBMARKET \
    GLOBALLISTOFACTIONS_initial
#endif /* HAVE_JOBMARKET */

#ifdef HAVE_LEVMAR
#define GLOBALLISTOFACTIONS_LEVMAR \
    BOOST_PP_SEQ_PUSH_BACK( \
        GLOBALLISTOFACTIONS_JOBMARKET, \
        PotentialFitPotential \
    )
#else
#define GLOBALLISTOFACTIONS_LEVMAR \
    GLOBALLISTOFACTIONS_JOBMARKET
#endif /* HAVE_LEVMAR */

// define final list
#ifdef HAVE_PYTHON
#define GLOBALLISTOFACTIONS_PYTHON \
    BOOST_PP_SEQ_PUSH_BACK( \
        GLOBALLISTOFACTIONS_LEVMAR, \
        CommandLoadSession \
    )
#else
#define GLOBALLISTOFACTIONS_PYTHON \
    GLOBALLISTOFACTIONS_LEVMAR
#endif

#define GLOBALLISTOFACTIONS GLOBALLISTOFACTIONS_PYTHON

// define python list
// skips CommandLoadSession as this causes dangerous infinite loops
#define GLOBALLISTOFPYTHONACTIONS \
  GLOBALLISTOFACTIONS_LEVMAR

#endif /* GLOBALLISTOFACTIONS_HPP_ */

