/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"


TextDialog::StringsTextQuery::StringsTextQuery(string title, std::string _description) :
    Dialog::StringsQuery(title,_description)
{}

TextDialog::StringsTextQuery::~StringsTextQuery() {}

bool TextDialog::StringsTextQuery::handle() {
  std::cout << getDescription() << ": ";
  getline(std::cin,temp);
  // dissect by " "
  std::string::iterator olditer = temp.begin();
  for(string::iterator iter = temp.begin(); iter != temp.end(); ++iter) {
    if (*iter == ' ') {
      tmp.push_back(string(iter, olditer));
      olditer = iter;
    }
  }
  if (olditer != temp.begin())  // insert last part also
    tmp.push_back(string(olditer, temp.end()));

  return true;
}

