/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Matrix.hpp"


TextDialog::BoxTextQuery::BoxTextQuery(std::string title, std::string _description) :
    Dialog::BoxQuery(title,_description)
{}

TextDialog::BoxTextQuery::~BoxTextQuery()
{}

bool TextDialog::BoxTextQuery::handle() {
  std::cout << getTitle();

  double temp[6];
  std::cout << getDescription() << " - ";
  std::string coords[6] = {"xx","yx","yy", "zx", "zy", "zz"};
  for (int i=0;i<6;i++) {
    std::cout << coords[i] << ": ";
    std::cin >> temp[i];
  }
  Matrix M;
  M.set(0,0, temp[0]);
  M.set(0,1, temp[1]);
  M.set(0,2, temp[2]);
  M.set(1,0, temp[1]);
  M.set(1,1, temp[3]);
  M.set(1,2, temp[4]);
  M.set(2,0, temp[2]);
  M.set(2,1, temp[4]);
  M.set(2,2, temp[5]);
  tmp.setM(M);
  return true;
}

