/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qspinbox.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/UnsignedIntQtQueryPipe.hpp"


QtDialog::UnsignedIntQtQuery::UnsignedIntQtQuery(std::string _title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::UnsignedIntQuery(_title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QSpinBox();
  inputBox->setValue(0);
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  pipe = new UnsignedIntQtQueryPipe(&tmp,_dialog);
  pipe->update(inputBox->value());
  connect(inputBox,SIGNAL(valueChanged(unsigned int)),pipe,SLOT(update(unsigned int)));
}

QtDialog::UnsignedIntQtQuery::~UnsignedIntQtQuery()
{
  delete pipe;
}

bool QtDialog::UnsignedIntQtQuery::handle() {
  return true;
}

