/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/MoleculeQtQueryPipe.hpp"

#include "molecule.hpp"
#include "World.hpp"


QtDialog::MoleculeQtQuery::MoleculeQtQuery(std::string _title, QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::MoleculeQuery(_title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QComboBox();
  // add all molecules to the combo box
  vector<molecule*> molecules = World::getInstance().getAllMolecules();
  for(vector<molecule*>::iterator iter  = molecules.begin();
      iter != molecules.end();
      ++iter) {
    std::stringstream sstr;
    sstr << (*iter)->IndexNr << "\t" << (*iter)->getName();
    inputBox->addItem(QString(sstr.str().c_str()),QVariant((*iter)->IndexNr));
  }
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  pipe = new MoleculeQtQueryPipe(&tmp,_dialog,inputBox);
  pipe->update(inputBox->currentIndex());
  connect(inputBox,SIGNAL(currentIndexChanged(int)),pipe,SLOT(update(int)));
}

QtDialog::MoleculeQtQuery::~MoleculeQtQuery()
{
  delete pipe;
}

// Handling is easy, since the GUI makes it impossible to select invalid values
bool QtDialog::MoleculeQtQuery::handle()
{
  return true;
}

