/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoubleQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QDoubleSpinBox>
#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/DoubleQtQueryPipe.hpp"


QtDialog::DoubleQtQuery::DoubleQtQuery(std::string title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::DoubleQuery(title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QDoubleSpinBox();
  inputBox->setValue(0);
  inputBox->setRange(-std::numeric_limits<double>::max(),std::numeric_limits<double>::max());
  inputBox->setDecimals(3);
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  pipe = new DoubleQtQueryPipe(&tmp,_dialog);
  pipe->update(inputBox->value());
  connect(inputBox,SIGNAL(valueChanged(double)),pipe,SLOT(update(double)));
}

QtDialog::DoubleQtQuery::~DoubleQtQuery()
{
  delete pipe;
}

bool QtDialog::DoubleQtQuery::handle() {
  return true;
}


