/*
 * PrincipalAxisSystemAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/PrincipalAxisSystemAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char AnalysisPrincipalAxisSystemAction::NAME[] = "principal-axis-system";

AnalysisPrincipalAxisSystemAction::AnalysisPrincipalAxisSystemAction() :
  Action(NAME)
{}

AnalysisPrincipalAxisSystemAction::~AnalysisPrincipalAxisSystemAction()
{}

void AnalysisPrincipalAxisSystem() {
  ActionRegistry::getInstance().getActionByName(AnalysisPrincipalAxisSystemAction::NAME)->call(Action::NonInteractive);
};

Dialog* AnalysisPrincipalAxisSystemAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performCall() {
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, mol);
  DoLog(0) && (Log() << Verbose(0) << "Evaluating prinicipal axis." << endl);
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    molecule *mol = iter->second;
    mol->PrincipalAxisSystem(false);
  }
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPrincipalAxisSystemAction::canUndo() {
  return true;
}

bool AnalysisPrincipalAxisSystemAction::shouldUndo() {
  return true;
}

const string AnalysisPrincipalAxisSystemAction::getName() {
  return NAME;
}
