/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * elements_db.cpp
 *
 *  Created on: 17.05.2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

const char *elementsDB =\
"#	Covalent	radius	of	each	element	in	Angstroem	from	CSD	(binding	is:	[Rcov(A)+Rcov(B)-t,Rcov(A)+Rcov(B)+t]	with	t	=	0.4A\n\
#Element	Name	Symbol	Period	Group	Block	Atomic	Number	AtomicWeight	Covalent	Radius	vdW	Radius\n\
Hydrogen	H	1	1	s	1	1.008	0.23	1.09\n\
Helium	He	1	18	p	2	4.003	1.50	1.40\n\
Lithium	Li	2	1	s	3	6.941	0.68	1.82\n\
Beryllium	Be	2	2	s	4	9.012	0.35	2.00\n\
Boron	B	2	13	p	5	10.811	0.83	2.00\n\
Carbon	C	2	14	p	6	12.011	0.68	1.70\n\
Nitrogen	N	2	15	p	7	14.007	0.68	1.55\n\
Oxygen	O	2	16	p	8	15.999	0.68	1.52\n\
Fluorine	F	2	17	p	9	18.998	0.64	1.47\n\
Neon	Ne	2	18	p	10	20.180	1.50	1.54\n\
Sodium	Na	3	1	s	11	22.991	0.97	2.27\n\
Magnesium	Mg	3	2	s	12	24.305	1.10	1.73\n\
Aluminium	Al	3	13	p	13	26.982	1.35	2.00\n\
Silicon	Si	3	14	p	14	28.086	1.20	2.10\n\
Phosphorus	P	3	15	p	15	30.974	1.05	1.80\n\
Sulphur	S	3	16	p	16	32.066	1.02	1.80\n\
Chlorine	Cl	3	17	p	17	35.453	0.99	1.75\n\
Argon	Ar	3	18	p	18	39.948	1.51	1.88\n\
Potassium	K	4	1	s	19	39.098	1.33	2.75\n\
Calcium	Ca	4	2	s	20	40.078	0.99	2.00\n\
Scandium	Sc	4	3	d	21	44.956	1.44	2.00\n\
Titanium	Ti	4	4	d	22	47.867	1.47	2.00\n\
Vanadium	V	4	5	d	23	50.942	1.33	2.00\n\
Chromium	Cr	4	6	d	24	51.996	1.35	2.00\n\
Manganese	Mn	4	7	d	25	54.938	1.35	2.00\n\
Iron	Fe	4	8	d	26	55.845	1.34	2.00\n\
Cobalt	Co	4	9	d	27	58.933	1.33	2.00\n\
Nickel	Ni	4	10	d	28	58.693	1.50	1.63\n\
Copper	Cu	4	11	d	29	63.546	1.52	1.40\n\
Zinc	Zn	4	12	d	30	65.390	1.45	1.39\n\
Gallium	Ga	4	13	p	31	69.723	1.22	1.87\n\
Germanium	Ge	4	14	p	32	72.610	1.17	2.00\n\
Arsenic	As	4	15	p	33	74.922	1.21	1.85\n\
Selenium	Se	4	16	p	34	78.960	1.22	1.90\n\
Bromine	Br	4	17	p	35	79.904	1.21	1.85\n\
Krypton	Kr	4	18	p	36	83.800	1.50	2.02\n\
Rubidium	Rb	5	1	s	37	85.468	1.47	2.00\n\
Strontium	Sr	5	2	s	38	87.620	1.12	2.00\n\
Yttrium	Y	5	3	d	39	88.906	1.78	2.00\n\
Zirconium	Zr	5	4	d	40	91.224	1.56	2.00\n\
Niobium	Nb	5	5	d	41	92.906	1.48	2.00\n\
Molybdenum	Mo	5	6	d	42	95.940	1.47	2.00\n\
Technetium	Tc	5	7	d	43	98	1.35	2.00\n\
Ruthenium	Ru	5	8	d	44	101.070	1.40	2.00\n\
Rhodium	Rh	5	9	d	45	102.906	1.45	2.00\n\
Palladium	Pd	5	10	d	46	106.420	1.50	1.63\n\
Silver	Ag	5	11	d	47	107.868	1.59	1.72\n\
Cadmium	Cd	5	12	d	48	112.411	1.69	1.58\n\
Indium	In	5	13	p	49	114.818	1.63	1.93\n\
Tin	Sn	5	14	p	50	118.71	1.46	2.17\n\
Antimony	Sb	5	15	p	51	121.760	1.46	2.00\n\
Tellurium	Te	5	16	p	52	127.600	1.47	2.06\n\
Iodine	I	5	17	p	53	126.904	1.40	1.98\n\
Xenon	Xe	5	18	p	54	131.290	1.50	2.16\n\
Caesium	Cs	6	1	s	55	132.905	1.67	2.00\n\
Barium	Ba	6	2	s	56	137.327	1.34	2.00\n\
Lutetium	Lu	6	3	d	71	174.967	1.72	2.00\n\
Hafnium	Hf	6	4	d	72	178.490	1.57	2.00\n\
Tantalum	Ta	6	5	d	73	180.948	1.43	2.00\n\
Tungsten	W	6	6	d	74	183.840	1.37	2.00\n\
Rhenium	Re	6	7	d	75	186.207	1.35	2.00\n\
Osmium	Os	6	8	d	76	190.230	1.37	2.00\n\
Iridium	Ir	6	9	d	77	192.217	1.32	2.00\n\
Platinum	Pt	6	10	d	78	195.078	1.50	1.72\n\
Gold	Au	6	11	d	79	196.967	1.50	1.66\n\
Mercury	Hg	6	12	d	80	200.590	1.70	1.55\n\
Thallium	Tl	6	13	p	81	204.383	1.55	1.96\n\
Lead	Pb	6	14	p	82	207.200	1.54	2.02\n\
Bismuth	Bi	6	15	p	83	208.980	1.54	2.00\n\
Polonium	Po	6	16	p	84	210	1.68	2.00\n\
Astatine	At	6	17	p	85	210	1.21	2.00\n\
Radon	Rn	6	18	p	86	222	1.50	2.00\n\
Cerium	Ce	6Lan	19	f	58	140.116	1.83	2.00\n\
Dysprosium	Dy	6Lan	19	f	66	162.500	1.75	2.00\n\
Erbium	Er	6Lan	19	f	68	167.260	1.73	2.00\n\
Europium	Eu	6Lan	19	f	63	151.964	1.99	2.00\n\
Gadolinium	Gd	6Lan	19	f	64	157.250	1.79	2.00\n\
Holmium	Ho	6Lan	19	f	67	164.930	1.74	2.00\n\
Lanthanum	La	6Lan	19	f	57	138.906	1.87	2.00\n\
Neodymium	Nd	6Lan	19	f	60	144.240	1.81	2.00\n\
Promethium	Pm	6Lan	19	f	61	145	1.80	2.00\n\
Praseodymium	Pr	6Lan	19	f	59	140.908	1.82	2.00\n\
Samarium	Sm	6Lan	19	f	62	150.360	1.80	2.00\n\
Terbium	Tb	6Lan	19	f	65	158.925	1.76	2.00\n\
Thulium	Tm	6Lan	19	f	69	168.934	1.72	2.00\n\
Ytterbium	Yb	6Lan	19	f	70	173.040	1.94	2.00\n\
Francium	Fr	7	1	s	87	223	1.50	2.00\n\
Radium	Ra	7	2	s	88	226	1.90	2.00\n\
Lawrencium	Lr	7	3	d	103	262	1.50	2.00\n\
Rutherfordium	Rf	7	4	d	104	261	1.50	2.00\n\
Dubnium	Db	7	5	d	105	262	1.50	2.00\n\
Seaborgium	Sg	7	6	d	106	266	1.50	2.00\n\
Bohrium	Bh	7	7	d	107	264	1.50	2.00\n\
Hassium	Hs	7	8	d	108	269	1.50	2.00\n\
Meitnerium	Mt	7	9	d	109	268	1.50	2.00\n\
Darmstadtium	Ds	7	10	d	110	271	1.50	2.00\n\
Actinium	Ac	7Act	20	f	89	227	1.88	2.00\n\
Americium	Am	7Act	20	f	95	243	1.51	2.00\n\
Berkelium	Bk	7Act	20	f	97	247	1.54	2.00\n\
Californium	Cf	7Act	20	f	98	251	1.83	2.00\n\
Curium	Cm	7Act	20	f	96	247	0.99	2.00\n\
Einsteinium	Es	7Act	20	f	99	252	1.50	2.00\n\
Fermium	Fm	7Act	20	f	100	257	1.50	2.00\n\
Mendelevium	Md	7Act	20	f	101	258	1.50	2.00\n\
Nobelium	No	7Act	20	f	102	259	1.50	2.00\n\
Neptunium	Np	7Act	20	f	93	237	1.55	2.00\n\
Protactinium	Pa	7Act	20	f	91	231.036	1.61	2.00\n\
Plutonium	Pu	7Act	20	f	94	244	1.53	2.00\n\
Thorium	Th	7Act	20	f	90	232.038	1.79	2.00\n\
Uranium	U	7Act	20	f	92	238.029	1.58	1.86\n\
";

const char *ElectronegativitiesDB =\
"#atomic number\tEN [Pauling units], taken from http://en.wikipedia.org/wiki/Electronegativities_of_the_elements_%28data_page%29\n\
1 2.2\n\
2 -1\n\
3 0.98\n\
4 1.57\n\
5 2.04\n\
6 2.55\n\
7 3.04\n\
8 3.44\n\
9  3.98\n\
10  -1\n\
11  0.93\n\
12  1.31\n\
13  1.61\n\
14  1.90\n\
15  2.19\n\
16  2.58\n\
17  3.16\n\
18  -1\n\
19  0.82\n\
20  1.00\n\
21  1.36\n\
22  1.54\n\
23  1.63\n\
24  1.66\n\
25  1.55\n\
26  1.83\n\
27  1.88\n\
28  1.91\n\
29  1.90\n\
30  1.65\n\
31  1.81\n\
32  2.01\n\
33  2.18\n\
34  2.55\n\
35  2.96\n\
36  3.00\n\
37  0.82\n\
38  0.95\n\
39  1.22\n\
40  1.33\n\
41  1.6\n\
42  2.16\n\
43  1.9\n\
44  2.2\n\
45  2.28\n\
46  2.20\n\
47  1.93\n\
48  1.69\n\
49  1.78\n\
50  1.96\n\
51  2.05\n\
52  2.1\n\
53  2.66\n\
54  2.6\n\
55  0.79\n\
56  0.89\n\
57  1.10\n\
58  1.12\n\
59  1.13\n\
60  1.14\n\
61  -1\n\
62  1.17\n\
63  -1\n\
64  1.20\n\
65  -1\n\
66  1.22\n\
67  1.23\n\
68  1.24\n\
69  1.25\n\
70  -1\n\
71  1.27\n\
72  1.3\n\
73  1.5\n\
74  2.36\n\
75  1.9\n\
76  2.2\n\
77  2.20\n\
78  2.28\n\
79  2.54\n\
80  2.00\n\
81  1.62\n\
82  2.33\n\
83  2.02\n\
84  2.0\n\
85  2.2\n\
86  -1\n\
87  0.7\n\
88  0.9\n\
89  1.1\n\
90  1.3\n\
91  1.5\n\
92  1.38\n\
93  1.36\n\
94  1.28\n\
95  1.3\n\
96  1.3\n\
97  1.3\n\
98  1.3\n\
99  1.3\n\
100 1.3\n\
101 1.3\n\
102 1.3\n\
";

const char *HbonddistanceDB =\
"#atomic number bond distances for single, double and triple bond (-1 no bond)\n\
1	0.74	-1	-1\n\
2	0.77429209	-1	-1\n\
5	1.23	1.19	1.18\n\
6	1.09	1.076	1.06\n\
7	1.04	1.02	1.01\n\
8	0.96	0.957	-1\n\
14	1.48	1.48	1.48\n\
15	1.42	-1	-1\n\
16	1.35	-1	-1\n\
17	1.29	-1	-1\n\
20	1.09	1.09	-1\n\
34	1.47	-1	-1\n\
35	1.44	-1	-1\n\
";

const char *HbondangleDB =\
"# atomicnumber angles for single, double and triple bond (-1 no angle)\n\
1	180	-1	-1\n\
5	180	131.0	109.2\n\
6	180	120	109.47\n\
7	180	110	106.67\n\
8	180	104.5	-1\n\
14	180	120	109.47\n\
15	180	-1	-1\n\
16	180	-1	-1\n\
17	180 -1 -1\n\
20	180	120	109.47\n\
34	180 -1 -1\n\
35	180 -1 -1\n\
";

const char *orbitalsDB =\
"# atomicnumber	numberoforbitals\n\
1	1\n\
2	0\n\
3	1\n\
4	2\n\
5	3\n\
6	4\n\
7	3\n\
8	2\n\
9	1\n\
10	0\n\
11	1\n\
12	2\n\
13	3\n\
14	4\n\
15	3\n\
16	2\n\
17	1\n\
18	0\n\
19	1\n\
20	4\n\
21	3\n\
22	4\n\
23	5\n\
24	6\n\
25	4\n\
26	3\n\
27	3\n\
28	2\n\
29	2\n\
30	2\n\
31	3\n\
32	4\n\
33	3\n\
34	2\n\
35	1\n\
36	0\n\
37	1\n\
38	2\n\
39	3\n\
40	4\n\
41	5\n\
42	6\n\
43	6\n\
44	8\n\
45	4\n\
46	4\n\
47	1\n\
48	2\n\
49	3\n\
50	4\n\
51	3\n\
52	2\n\
53	1\n\
54	0\n\
55	1\n\
56	2\n\
57	3\n\
58	4\n\
59	3\n\
60	4\n\
61	3\n\
62	3\n\
63	3\n\
64	3\n\
65	4\n\
66	3\n\
67	3\n\
68	3\n\
69	3	\n\
70	3\n\
71	3\n\
72	4\n\
73	5\n\
74	6\n\
75	7\n\
76	8\n\
77	6\n\
78	6\n\
79	3\n\
80	2\n\
81	3\n\
82	4\n\
83	3\n\
84	4\n\
86	0\n\
88	2\n\
89	3\n\
90	4\n\
91	5\n\
92	6\n\
";

const char *valenceDB =\
"#atomicnumber numberofvalenceorbitals\n\
1	0.10000000000000E+01\n\
2	0.20000000000000E+01\n\
3	0.10000000000000E+01\n\
4	0.20000000000000E+01\n\
5	0.30000000000000E+01\n\
6	0.40000000000000E+01\n\
7	0.50000000000000E+01\n\
8	0.60000000000000E+01\n\
9	0.70000000000000E+01\n\
10	0.80000000000000E+01\n\
11	0.10000000000000E+01\n\
12	0.40000000000000E+01\n\
13	.3000000000000000E+01\n\
14	0.40000000000000E+01\n\
15	0.50000000000000E+01\n\
16	0.60000000000000E+01\n\
17	0.70000000000000E+01\n\
18	0.80000000000000E+01\n\
19	0.30000000000000E+01\n\
20	0.40000000000000E+01\n\
21	0.30000000000000E+01\n\
22	0.40000000000000E+01\n\
23	0.50000000000000E+01\n\
24	0.60000000000000E+01\n\
25	0.70000000000000E+01\n\
26	0.80000000000000E+01\n\
27	0.90000000000000E+01\n\
28	0.10000000000000E+02\n\
29	0.11000000000000E+02\n\
30	0.12000000000000E+02\n\
31	3.00000000000000000\n\
32	0.40000000000000E+01\n\
33	5.00000000000000000\n\
34	0.60000000000000E+01\n\
35	0.70000000000000E+01\n\
36	0.80000000000000E+01\n\
37	0.10000000000000E+01\n\
38	0.20000000000000E+01\n\
39	0.30000000000000E+01\n\
40	0.40000000000000E+01\n\
41	0.50000000000000E+01\n\
42	0.60000000000000E+01\n\
43	0.70000000000000E+01\n\
44	0.80000000000000E+01\n\
45	0.90000000000000E+01\n\
46	0.10000000000000E+02\n\
47	0.11000000000000E+02\n\
48	0.12000000000000E+02\n\
49	0.30000000000000E+01\n\
50	0.40000000000000E+01\n\
51	0.50000000000000E+01\n\
52	0.60000000000000E+01\n\
53	0.70000000000000E+01\n\
54	0.80000000000000E+01\n\
55	0.10000000000000E+01\n\
56	0.20000000000000E+01\n\
72	0.40000000000000E+01\n\
73	0.50000000000000E+01\n\
74	0.60000000000000E+01\n\
75	0.70000000000000E+01\n\
76	0.80000000000000E+01\n\
77	0.90000000000000E+01\n\
78	0.10000000000000E+02\n\
79	0.11000000000000E+02\n\
80	0.12000000000000E+02\n\
";

const char *ColorDB =\
"# AtomicNumber, symbol, [red, green, blue] component, hex value\n\
1\tH\t255\t255\t255\n\
2\tHe\t217\t255\t255\n\
3\tLi\t204\t128\t255\n\
4\tBe\t194\t255\t0\n\
5\tB\t255\t181\t181\n\
6\tC\t144\t144\t144\n\
7\tN\t48\t80\t248\n\
8\tO\t255\t13\t13\n\
9\tF\t144\t224\t80\n\
10\tNe\t179\t227\t245\n\
11\tNa\t171\t92\t242\n\
12\tMg\t138\t255\t0\n\
13\tAl\t191\t166\t166\n\
14\tSi\t240\t200\t160\n\
15\tP\t255\t128\t0\n\
16\tS\t255\t255\t48\n\
17\tCl\t31\t240\t31\n\
18\tAr\t128\t209\t227\n\
19\tK\t143\t64\t212\n\
20\tCa\t61\t255\t0\n\
21\tSc\t230\t230\t230\n\
22\tTi\t191\t194\t199\n\
23\tV\t166\t166\t171\n\
24\tCr\t138\t153\t199\n\
25\tMn\t156\t122\t199\n\
26\tFe\t224\t102\t51\n\
27\tCo\t240\t144\t160\n\
28\tNi\t80\t208\t80\n\
29\tCu\t200\t128\t51\n\
30\tZn\t125\t128\t176\n\
31\tGa\t194\t143\t143\n\
32\tGe\t102\t143\t143\n\
33\tAs\t189\t128\t227\n\
34\tSe\t255\t161\t0\n\
35\tBr\t166\t41\t41\n\
36\tKr\t92\t184\t209\n\
37\tRb\t112\t46\t176\n\
38\tSr\t0\t255\t0\n\
39\tY\t148\t255\t255\n\
40\tZr\t148\t224\t224\n\
41\tNb\t115\t194\t201\n\
42\tMo\t84\t181\t181\n\
43\tTc\t59\t158\t158\n\
44\tRu\t36\t143\t143\n\
45\tRh\t10\t125\t140\n\
46\tPd\t0\t105\t133\n\
47\tAg\t192\t192\t192\n\
48\tCd\t255\t217\t143\n\
49\tIn\t166\t117\t115\n\
50\tSn\t102\t128\t128\n\
51\tSb\t158\t99\t181\n\
52\tTe\t212\t122\t0\n\
53\tI\t148\t0\t148\n\
54\tXe\t66\t158\t176\n\
55\tCs\t87\t23\t143\n\
56\tBa\t0\t201\t0\n\
57\tLa\t112\t212\t255\n\
58\tCe\t255\t255\t199\n\
59\tPr\t217\t255\t199\n\
60\tNd\t199\t255\t199\n\
61\tPm\t163\t255\t199\n\
62\tSm\t143\t255\t199\n\
63\tEu\t97\t255\t199\n\
64\tGd\t69\t255\t199\n\
65\tTb\t48\t255\t199\n\
66\tDy\t31\t255\t199\n\
67\tHo\t0\t255\t156\n\
68\tEr\t0\t230\t117\n\
69\tTm\t0\t212\t82\n\
70\tYb\t0\t191\t56\n\
71\tLu\t0\t171\t36\n\
72\tHf\t77\t194\t255\n\
73\tTa\t77\t166\t255\n\
74\tW\t33\t148\t214\n\
75\tRe\t38\t125\t171\n\
76\tOs\t38\t102\t150\n\
77\tIr\t23\t84\t135\n\
78\tPt\t208\t208\t224\n\
79\tAu\t255\t209\t35\n\
80\tHg\t184\t184\t208\n\
81\tTl\t166\t84\t77\n\
82\tPb\t87\t89\t97\n\
83\tBi\t158\t79\t181\n\
84\tPo\t171\t92\t0\n\
85\tAt\t117\t79\t69\n\
86\tRn\t66\t130\t150\n\
87\tFr\t66\t0\t102\n\
88\tRa\t0\t125\t0\n\
89\tAc\t112\t171\t250\n\
90\tTh\t0\t186\t255\n\
91\tPa\t0\t161\t255\n\
92\tU\t0\t143\t255\n\
93\tNp\t0\t128\t255\n\
94\tPu\t0\t107\t255\n\
95\tAm\t84\t92\t242\n\
96\tCm\t120\t92\t227\n\
97\tBk\t138\t79\t227\n\
98\tCf\t161\t54\t212\n\
99\tEs\t179\t31\t212\n\
100\tFm\t179\t31\t186\n\
101\tMd\t179\t13\t166\n\
102\tNo\t189\t13\t135\n\
103\tLr\t199\t0\t102\n\
104\tRf\t204\t0\t89\n\
105\tDb\t209\t0\t79\n\
106\tSg\t217\t0\t69\n\
107\tBh\t224\t0\t56\n\
108\tHs\t230\t0\t46\n\
";
