/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SetTremoloAtomdataAction.cpp
 *
 *  Created on: Aug 9, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "SetTremoloAtomdataAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetTremoloAtomdataAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSetTremoloAtomdataAction::performCall() {
  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();

  LOG(1, "Setting Tremolo's ATOMDATA to: '" << params.atomdata_string.get() << "'");

  const std::string old_atomdata = parser.getAtomData();

  if (params.atomdata_reset.get())
    parser.resetAtomData(params.atomdata_string.get());
  else
    parser.setAtomData(params.atomdata_string.get());

  return Action::state_ptr(new ParserSetTremoloAtomdataState(old_atomdata, params));
}

Action::state_ptr ParserSetTremoloAtomdataAction::performUndo(Action::state_ptr _state) {
  ParserSetTremoloAtomdataState *state = assert_cast<ParserSetTremoloAtomdataState*>(_state.get());

  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();
  LOG(1, "INFO: Reverting to 'ATOMDATA " << state->old_atomdata << "'.");
  parser.resetAtomData(state->old_atomdata);

  return Action::state_ptr(_state);
}

Action::state_ptr ParserSetTremoloAtomdataAction::performRedo(Action::state_ptr _state){
  ParserSetTremoloAtomdataState *state = assert_cast<ParserSetTremoloAtomdataState*>(_state.get());

  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();

  if (state->params.atomdata_reset.get())
    parser.resetAtomData(state->params.atomdata_string.get());
  else
    parser.setAtomData(state->params.atomdata_string.get());

  return Action::state_ptr(_state);
}

bool ParserSetTremoloAtomdataAction::canUndo() {
  return true;
}

bool ParserSetTremoloAtomdataAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
