/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParseTremoloPotentialsAction.cpp
 *
 *  Created on: Feb 9, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "ParseTremoloPotentialsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ParseTremoloPotentialsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserParseTremoloPotentialsAction::performCall() {
  boost::filesystem::ifstream test;
  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();
  // parsing file if present
  if (!boost::filesystem::exists(params.filename.get())) {
    LOG(1, "Specified potentials file " << params.filename.get() << " not found.");
    // DONT FAIL: it's just empty we re-create default id-mapping
    parser.createKnownTypesByIdentity();

  } else {
    LOG(1, "Specified potentials file found, parsing ... ");

    // parse the file
    test.open(params.filename.get());
    parser.parseKnownTypes(test);
    test.close();
  }

  return Action::success;
}

Action::state_ptr ParserParseTremoloPotentialsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserParseTremoloPotentialsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserParseTremoloPotentialsAction::canUndo() {
  return false;
}

bool ParserParseTremoloPotentialsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
