/*
 * molecule_template.hpp
 *
 *  Created on: Oct 6, 2009
 *      Author: heber
 */

#ifndef MOLECULE_TEMPLATE_HPP_
#define MOLECULE_TEMPLATE_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/********************************************** declarations *******************************/

// ================== Acting on all Vectors ========================== //

// zero arguments
template <typename res> void molecule::ActOnAllVectors( res (Vector::*f)() ) const
    {
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)();
  }
};
template <typename res> void molecule::ActOnAllVectors( res (Vector::*f)() const ) const
    {
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)();
  }
};
// one argument
template <typename res, typename T> void molecule::ActOnAllVectors( res (Vector::*f)(T), T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t);
  }
};
template <typename res, typename T> void molecule::ActOnAllVectors( res (Vector::*f)(T) const, T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t);
  }
};
// two arguments
template <typename res, typename T, typename U> void molecule::ActOnAllVectors( res (Vector::*f)(T, U), T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t, u);
  }
};
template <typename res, typename T, typename U> void molecule::ActOnAllVectors( res (Vector::*f)(T, U) const, T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t, u);
  }
};
// three arguments
template <typename res, typename T, typename U, typename V> void molecule::ActOnAllVectors( res (Vector::*f)(T, U, V), T t, U u, V v) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t, u, v);
  }
};
template <typename res, typename T, typename U, typename V> void molecule::ActOnAllVectors( res (Vector::*f)(T, U, V) const, T t, U u, V v) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    ((Walker->node)->*f)(t, u, v);
  }
};

// ========================= Summing over each Atoms =================================== //

// zero arguments
template <typename res, typename typ> res molecule::SumPerAtom(res (typ::*f)() ) const
{
  res result = 0;
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    result += (Walker->*f)();
  }
  return result;
};
template <typename res, typename typ> res molecule::SumPerAtom(res (typ::*f)() const ) const
{
  res result = 0;
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    result += (Walker->*f)();
  }
  return result;
};
// one argument
template <typename res, typename typ, typename T> res molecule::SumPerAtom(res (typ::*f)(T), T t ) const
{
  res result = 0;
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    result += (Walker->*f)(t);
  }
  return result;
};
template <typename res, typename typ, typename T> res molecule::SumPerAtom(res (typ::*f)(T) const, T t ) const
{
  res result = 0;
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    result += (Walker->*f)(t);
  }
  return result;
};


// ================== Acting with each Atoms on same molecule ========================== //

// zero arguments
template <typename res> void molecule::ActWithEachAtom( res (molecule::*f)(atom *)) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*f)(Walker);
  }
};
template <typename res> void molecule::ActWithEachAtom( res (molecule::*f)(atom *) const) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*f)(Walker);
  }
};

// ================== Acting with each Atoms on copy molecule ========================== //

// zero arguments
template <typename res> void molecule::ActOnCopyWithEachAtom( res (molecule::*f)(atom *) , molecule *copy) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (copy->*f)(Walker);
  }
};
template <typename res> void molecule::ActOnCopyWithEachAtom( res (molecule::*f)(atom *) const, molecule *copy) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (copy->*f)(Walker);
  }
};

// ================== Acting with each Atoms on copy molecule if true ========================== //

// zero arguments
template <typename res> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) () ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)())
      (copy->*f)(Walker);
  }
};
template <typename res> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) () const ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)())
      (copy->*f)(Walker);
  }
};
template <typename res> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const , molecule *copy, bool (atom::*condition) () ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)())
      (copy->*f)(Walker);
  }
};
template <typename res> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) () const ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)())
      (copy->*f)(Walker);
  }
};
// one argument
template <typename res, typename T> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T), T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T) const, T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T), T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T) const, T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t))
      (copy->*f)(Walker);
  }
};
// two arguments
template <typename res, typename T, typename U> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T, U), T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T, U) const, T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T, U), T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T, U) const, T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u))
      (copy->*f)(Walker);
  }
};
// three arguments
template <typename res, typename T, typename U, typename V> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T, U, V), T t, U u, V v ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u,v))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U, typename V> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) , molecule *copy, bool (atom::*condition) (T, U, V) const, T t, U u, V v ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u,v))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U, typename V> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T, U, V), T t, U u, V v ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u,v))
      (copy->*f)(Walker);
  }
};
template <typename res, typename T, typename U, typename V> void molecule::ActOnCopyWithEachAtomIfTrue( res (molecule::*f)(atom *) const, molecule *copy, bool (atom::*condition) (T, U, V) const, T t, U u, V v ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    if ((Walker->*condition)(t,u,v))
      (copy->*f)(Walker);
  }
};

// ================== Acting on all Atoms ========================== //

// zero arguments
template <typename res, typename typ> void molecule::ActOnAllAtoms( res (typ::*f)()) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)();
  }
};
template <typename res, typename typ> void molecule::ActOnAllAtoms( res (typ::*f)() const) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)();
  }
};
// one argument
template <typename res, typename typ, typename T> void molecule::ActOnAllAtoms( res (typ::*f)(T), T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t);
  }
};
template <typename res, typename typ, typename T> void molecule::ActOnAllAtoms( res (typ::*f)(T) const, T t ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t);
  }
};
// two argument
template <typename res, typename typ, typename T, typename U> void molecule::ActOnAllAtoms( res (typ::*f)(T, U), T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u);
  }
};
template <typename res, typename typ, typename T, typename U> void molecule::ActOnAllAtoms( res (typ::*f)(T, U) const, T t, U u ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u);
  }
};
// three argument
template <typename res, typename typ, typename T, typename U, typename V> void molecule::ActOnAllAtoms( res (typ::*f)(T, U, V), T t, U u, V v) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u, v);
  }
};
template <typename res, typename typ, typename T, typename U, typename V> void molecule::ActOnAllAtoms( res (typ::*f)(T, U, V) const, T t, U u, V v) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u, v);
  }
};
// four arguments
template <typename res, typename typ, typename T, typename U, typename V, typename W> void molecule::ActOnAllAtoms( res (typ::*f)(T, U, V, W), T t, U u, V v, W w) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u, v, w);
  }
};
template <typename res, typename typ, typename T, typename U, typename V, typename W> void molecule::ActOnAllAtoms( res (typ::*f)(T, U, V, W) const, T t, U u, V v, W w) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (Walker->*f)(t, u, v, w);
  }
};

// ===================== Accessing arrays indexed by some integer for each atom ======================

// for atom ints
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, void (*Setor)(T *, T *) ) const
{
  atom *Walker = start;
  int inc = 1;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->*index)], &inc);
  }
};
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, void (*Setor)(T *, T *), T value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->*index)], &value);
  }
};
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, void (*Setor)(T *, T *), T *value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->*index)], value);
  }
};
// for element ints
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int element::*index, void (*Setor)(T *, T *) ) const
{
  atom *Walker = start;
  int inc = 1;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->type->*index)], &inc);
  }
};
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int element::*index, void (*Setor)(T *, T *), T value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->type->*index)], &value);
  }
};
template <typename T> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int element::*index, void (*Setor)(T *, T *), T *value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    (*Setor) (&array[(Walker->type->*index)], value);
  }
};

template <typename T, typename typ> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, T (atom::*Setor)(typ &), typ atom::*value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    array[(Walker->*index)] = (Walker->*Setor) (Walker->*value);
  }
};
template <typename T, typename typ> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, T (atom::*Setor)(typ &) const, typ atom::*value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    array[(Walker->*index)] = (Walker->*Setor) (Walker->*value);
  }
};
template <typename T, typename typ> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, T (atom::*Setor)(typ &), typ &vect ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    array[(Walker->*index)] = (Walker->*Setor) (vect);
  }
};
template <typename T, typename typ> void molecule::SetIndexedArrayForEachAtomTo ( T *array, int ParticleInfo::*index, T (atom::*Setor)(typ &) const, typ &vect ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    array[(Walker->*index)] = (Walker->*Setor) (vect);
  }
};
template <typename T, typename typ, typename typ2> void molecule::SetAtomValueToIndexedArray ( T *array, int typ::*index, T typ2::*value ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    Walker->*value = array[(Walker->*index)];
    //cout << Verbose(2) << *Walker << " gets " << (Walker->*value); << endl;
  }
};

template <typename T, typename typ> void molecule::SetAtomValueToValue ( T value, T typ::*ptr ) const
{
  atom *Walker = start;
  while (Walker->next != end) {
    Walker = Walker->next;
    Walker->*ptr = value;
    //cout << Verbose(2) << *Walker << " gets " << (Walker->*ptr) << endl;
  }
};


#endif /* MOLECULE_TEMPLATE_HPP_ */
