/*
 * KeySetsContainer.hpp
 *
 *  Created on: Sep 15, 2011
 *      Author: heber
 */

#ifndef KEYSETSCONTAINER_HPP_
#define KEYSETSCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/vector.hpp"

#include <vector>

/** Contains the index set for each fragment.
 *
 */
class KeySetsContainer {
  public:
    typedef std::vector<int> IntVector;
    typedef std::vector<IntVector> ArrayOfIntVectors;
    ArrayOfIntVectors KeySets;
    IntVector AtomCounter;
    int FragmentCounter;
    int Order;
    IntVector FragmentsPerOrder;
    ArrayOfIntVectors OrderSet;

  KeySetsContainer();
  ~KeySetsContainer();

  bool ParseKeySets(const std::string name, const std::vector<int> ACounter, const int FCounter);
  bool ParseManyBodyTerms();
  bool Contains(const int GreaterSet, const int SmallerSet);

  bool operator==(const KeySetsContainer &other) const;

  bool operator!=(const KeySetsContainer &other) const {
    return !(*this == other);
  }

private:
  friend class boost::serialization::access;
  // serialization
  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & KeySets;
    ar & AtomCounter;
    ar & FragmentCounter;
    ar & Order;
    ar & FragmentsPerOrder;
    ar & OrderSet;
  }
};


#endif /* KEYSETSCONTAINER_HPP_ */
