/*
 * SurfaceInserter.hpp
 *
 *  Created on: Apr 03, 2012
 *      Author: heber
 */

#ifndef SURFACEINSERTER_HPP_
#define SURFACEINSERTER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Filling/Inserter/InserterBase.hpp"

#include "LinearAlgebra/Vector.hpp"
#include "Shapes/Shape.hpp"

/** SurfaceInserter implements Inserter interface such that the given \a Cluster
 * is inserted at the given position in such a way as to be aligned perpendicularly
 * away from the surface.
 *
 * \note We assume that cluster is aligned along the Z axis.
 *
 */
class SurfaceInserter : public InserterBase
{
public:
  SurfaceInserter(const Shape & _s, const Vector &_alignedAxis);
  ~SurfaceInserter();

  bool operator()(ClusterInterface::Cluster_impl cluster, const Vector &offset) const;

private:
  const Shape shape;
  const Vector alignedAxis;
};



#endif /* SURFACEINSERTER_HPP_ */
