/*
 * stackclassunittest.cpp
 *
 *  Created on: Oct 27, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "stackclassunittest.hpp"

enum { testdimension=3 };

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( StackClassTest );


void StackClassTest::setUp()
{
  Stack = new StackClass<int *>(testdimension);
};


void StackClassTest::tearDown()
{
  Stack->ClearStack();
  delete(Stack);
};

/** UnitTest for StackClass<T> implementation
 *
 */

void StackClassTest::TestImplementation()
{
  int testfield[testdimension] = {0,1,2};
  //cout << Verbose(1) << "Testing the snake stack..." << endl;
  for (int i=0;i<testdimension;i++) {
    //cout << Verbose(2) << "Filling " << i << "th element of stack." << endl;
    Stack->Push(&testfield[i]);
  }
  //cout << endl;
  //Output(out);
  CPPUNIT_ASSERT_EQUAL(true, Stack->IsFull());
  CPPUNIT_ASSERT_EQUAL(false, Stack->IsEmpty());
  CPPUNIT_ASSERT_EQUAL((testdimension) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[1]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-1) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[2]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-2) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[0]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-3) % (int)testdimension, Stack->ItemCount());

  Stack->ClearStack();
  CPPUNIT_ASSERT_EQUAL(false, Stack->IsFull());
  CPPUNIT_ASSERT_EQUAL(true, Stack->IsEmpty());
  CPPUNIT_ASSERT_EQUAL(0, Stack->ItemCount());
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
