/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SavePotentialsAction.cpp
 *
 *  Created on: Sep 12, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// and before MemDebug due to placement new
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "Actions/PotentialAction/SavePotentialsAction.hpp"

#include <boost/filesystem.hpp>
#include <fstream>

#include "CodePatterns/Log.hpp"

#include "Potentials/EmpiricalPotential.hpp"
#include "Potentials/Exceptions.hpp"
#include "Potentials/RegistrySerializer.hpp"
#include "Potentials/Particles/Particle.hpp"
#include "Potentials/Particles/ParticleRegistry.hpp"
#include "Potentials/PotentialRegistry.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SavePotentialsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

ActionState::ptr PotentialSavePotentialsAction::performCall()
{
  // store the potentials
  if (!params.potential_file.get().string().empty()) {
    std::ofstream returnstream(params.potential_file.get().string().c_str());
    if (returnstream.good()) {
      // print particles
      std::stringstream particles;
      RegistrySerializer<Particle> serialize(
          particles,
          ParticleRegistry::getInstance(),
          std::string("particle"));
      serialize();
      LOG(1, "STATUS: Resulting particles are " << std::endl << particles.str());
      returnstream << particles.str();
    } else {
      STATUS("Could not open stream to write particles!");
      return Action::failure;
    }
    if (returnstream.good()) {
      // print fitted potentials
      std::stringstream potentials;
      RegistrySerializer<EmpiricalPotential> serialize(
          potentials,
          PotentialRegistry::getInstance(),
          std::string("potential"));
      serialize();
      LOG(1, "STATUS: Resulting parameters are " << std::endl << potentials.str());
      returnstream << potentials.str();
    } else {
      STATUS("Could not open stream to write potentials!");
      return Action::failure;
    }
  } else {
    STATUS("No usable potential filename given!");
    return Action::failure;
  }

  return Action::success;
}

ActionState::ptr PotentialSavePotentialsAction::performUndo(ActionState::ptr _state) {
  STATUS("Undo of PotentialSavePotentialsAction not implemented.");
  return Action::failure;
}

ActionState::ptr PotentialSavePotentialsAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of PotentialSavePotentialsAction not implemented.");
  return Action::failure;
}

bool PotentialSavePotentialsAction::canUndo() {
  return false;
}

bool PotentialSavePotentialsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
