/*
 * FragmentScheduler.hpp
 *
 *  Created on: 18.11.2011
 *      Author: heber
 */

#ifndef STOCKSERVER_HPP_
#define STOCKSERVER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/asio.hpp>
#include <vector>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "FragmentJob.hpp"

/// Serves stock quote information to any client that connects to it.
class FragmentScheduler
{
public:
  /// Constructor opens the acceptor and starts waiting for the first incoming
  /// connection.
  FragmentScheduler(boost::asio::io_service& io_service, unsigned short port);

  /// Handle completion of a accept operation.
  void handle_accept(const boost::system::error_code& e, connection_ptr conn);

  /// Handle completion of a write operation.
  void handle_write(const boost::system::error_code& e, connection_ptr conn);

private:
  /// The acceptor object used to accept incoming socket connections.
  boost::asio::ip::tcp::acceptor acceptor_;

  /// The data to be sent to each client.
  std::vector<FragmentJob> jobs_;
};

#endif /* STOCKSERVER_HPP_ */
